/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.lib.header.OSGiHeader;
import aQute.lib.osgi.Instruction;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;

public class DependencyEmbedder {
    public static final String EMBED_DEPENDENCY = "Embed-Dependency";
    public static final String EMBED_DIRECTORY = "Embed-Directory";
    public static final String EMBED_STRIP_GROUP = "Embed-StripGroup";
    public static final String EMBED_STRIP_VERSION = "Embed-StripVersion";
    public static final String EMBED_TRANSITIVE = "Embed-Transitive";
    private final Collection dependencyArtifacts;
    private final Collection inlinedArtifacts;
    private final Collection embeddedArtifacts;

    public DependencyEmbedder(Collection dependencyArtifacts) {
        this.dependencyArtifacts = dependencyArtifacts;
        this.inlinedArtifacts = new HashSet();
        this.embeddedArtifacts = new HashSet();
    }

    public void processHeaders(Properties properties) throws MojoExecutionException {
        this.inlinedArtifacts.clear();
        this.embeddedArtifacts.clear();
        String embedDependencyHeader = properties.getProperty(EMBED_DEPENDENCY);
        if (null != embedDependencyHeader && embedDependencyHeader.length() > 0) {
            Map embedInstructions = OSGiHeader.parseHeader((String)embedDependencyHeader);
            this.processEmbedInstructions(embedInstructions);
            Iterator i = this.inlinedArtifacts.iterator();
            while (i.hasNext()) {
                DependencyEmbedder.inlineDependency(properties, (Artifact)i.next());
            }
            i = this.embeddedArtifacts.iterator();
            while (i.hasNext()) {
                DependencyEmbedder.embedDependency(properties, (Artifact)i.next());
            }
        }
    }

    protected void processEmbedInstructions(Map embedInstructions) throws MojoExecutionException {
        Iterator clauseIterator = embedInstructions.entrySet().iterator();
        while (clauseIterator.hasNext()) {
            boolean inline = false;
            HashSet filteredDependencies = new HashSet(this.dependencyArtifacts);
            Map.Entry clause = clauseIterator.next();
            DependencyFilter filter = new DependencyFilter((String)clause.getKey()){

                boolean matches(Artifact dependency) {
                    return super.matches(dependency.getArtifactId());
                }
            };
            filter.filter(filteredDependencies);
            Iterator attrIterator = ((Map)clause.getValue()).entrySet().iterator();
            while (attrIterator.hasNext()) {
                Map.Entry attr = attrIterator.next();
                if ("groupId".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        boolean matches(Artifact dependency) {
                            return super.matches(dependency.getGroupId());
                        }
                    };
                } else if ("artifactId".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        boolean matches(Artifact dependency) {
                            return super.matches(dependency.getArtifactId());
                        }
                    };
                } else if ("version".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        boolean matches(Artifact dependency) {
                            try {
                                return super.matches(dependency.getSelectedVersion().toString());
                            }
                            catch (Exception e) {
                                return super.matches(dependency.getVersion());
                            }
                        }
                    };
                } else if ("scope".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue(), "compile"){

                        boolean matches(Artifact dependency) {
                            return super.matches(dependency.getScope());
                        }
                    };
                } else if ("type".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue(), "jar"){

                        boolean matches(Artifact dependency) {
                            return super.matches(dependency.getType());
                        }
                    };
                } else if ("classifier".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        boolean matches(Artifact dependency) {
                            return super.matches(dependency.getClassifier());
                        }
                    };
                } else if ("optional".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue(), "false"){

                        boolean matches(Artifact dependency) {
                            return super.matches("" + dependency.isOptional());
                        }
                    };
                } else {
                    if ("inline".equals(attr.getKey())) {
                        inline = Boolean.valueOf((String)attr.getValue());
                        continue;
                    }
                    throw new MojoExecutionException("Unexpected attribute " + attr.getKey());
                }
                filter.filter(filteredDependencies);
            }
            if (inline) {
                this.inlinedArtifacts.addAll(filteredDependencies);
                continue;
            }
            this.embeddedArtifacts.addAll(filteredDependencies);
        }
        this.embeddedArtifacts.removeAll(this.inlinedArtifacts);
    }

    public static void embedDependency(Properties properties, Artifact dependency) {
        File sourceFile = dependency.getFile();
        if (null != sourceFile && sourceFile.exists()) {
            String extension;
            String bundleClassPath = properties.getProperty("Bundle-ClassPath");
            String includeResource = properties.getProperty("Include-Resource");
            if (null == bundleClassPath) {
                bundleClassPath = ".,";
            } else if (bundleClassPath.length() > 0) {
                bundleClassPath = bundleClassPath + ",";
            }
            if (null == includeResource) {
                includeResource = "";
            } else if (includeResource.length() > 0) {
                includeResource = includeResource + ",";
            }
            String embedDirectory = properties.getProperty(EMBED_DIRECTORY);
            String embedStripGroup = properties.getProperty(EMBED_STRIP_GROUP, "true");
            String embedStripVersion = properties.getProperty(EMBED_STRIP_VERSION);
            if ("".equals(embedDirectory) || ".".equals(embedDirectory)) {
                embedDirectory = null;
            }
            if (!Boolean.valueOf(embedStripGroup).booleanValue()) {
                embedDirectory = new File(embedDirectory, dependency.getGroupId()).getPath();
            }
            File targetFile = Boolean.valueOf(embedStripVersion).booleanValue() ? ((extension = dependency.getArtifactHandler().getExtension()) != null ? new File(embedDirectory, dependency.getArtifactId() + "." + extension) : new File(embedDirectory, dependency.getArtifactId())) : new File(embedDirectory, sourceFile.getName());
            String targetFilePath = targetFile.getPath();
            if (File.separatorChar != '/') {
                targetFilePath = targetFilePath.replace(File.separatorChar, '/');
            }
            bundleClassPath = bundleClassPath + targetFilePath;
            includeResource = includeResource + targetFilePath + "=" + sourceFile;
            properties.setProperty("Bundle-ClassPath", bundleClassPath);
            properties.setProperty("Include-Resource", includeResource);
        }
    }

    public static void inlineDependency(Properties properties, Artifact dependency) {
        File sourceFile = dependency.getFile();
        if (null != sourceFile && sourceFile.exists()) {
            String includeResource = properties.getProperty("Include-Resource");
            if (null == includeResource) {
                includeResource = "";
            } else if (includeResource.length() > 0) {
                includeResource = includeResource + ",";
            }
            includeResource = includeResource + "@" + sourceFile;
            properties.setProperty("Include-Resource", includeResource);
        }
    }

    public Collection getInlinedArtifacts() {
        return this.inlinedArtifacts;
    }

    public Collection getEmbeddedArtifacts() {
        return this.embeddedArtifacts;
    }

    protected static abstract class DependencyFilter {
        Instruction instruction;
        String defaultValue;

        public DependencyFilter(String expression) {
            this(expression, "");
        }

        public DependencyFilter(String expression, String defaultValue) {
            this.instruction = Instruction.getPattern((String)expression);
            this.defaultValue = defaultValue;
        }

        public void filter(Collection dependencies) {
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                if (this.matches((Artifact)i.next())) continue;
                i.remove();
            }
        }

        abstract boolean matches(Artifact var1);

        boolean matches(String text) {
            if (null == text) {
                text = this.defaultValue;
            }
            boolean result = this.instruction.matches(text);
            return this.instruction.isNegated() ? !result : result;
        }
    }
}

