/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.rocketmq.codec;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.Invocation;

public class RocketMQCodecSupport {
    private static final String DEFAULT_REMOTING_SERIALIZATION_PROPERTY = "hessian2";

    public static Serialization getRequestSerialization(URL url, Invocation invocation) {
        Object serializationTypeObj = invocation.get((Object)"serialization_id");
        if (serializationTypeObj != null) {
            return CodecSupport.getSerializationById((Byte)((Byte)serializationTypeObj));
        }
        return (Serialization)url.getOrDefaultFrameworkModel().getExtensionLoader(Serialization.class).getExtension(url.getParameter("serialization", DEFAULT_REMOTING_SERIALIZATION_PROPERTY));
    }

    public static Serialization getResponseSerialization(URL url, AppResponse appResponse) {
        Invocation invocation;
        Object serializationTypeObj;
        Object invocationObj = appResponse.getAttribute("invocation");
        if (invocationObj != null && (serializationTypeObj = (invocation = (Invocation)invocationObj).get((Object)"serialization_id")) != null) {
            return CodecSupport.getSerializationById((Byte)((Byte)serializationTypeObj));
        }
        return (Serialization)url.getOrDefaultFrameworkModel().getExtensionLoader(Serialization.class).getExtension(url.getParameter("serialization", DEFAULT_REMOTING_SERIALIZATION_PROPERTY));
    }
}

