/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.rocketmq.codec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.io.Bytes;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.exchange.codec.ExchangeCodec;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.rocketmq.codec.DecodeableRpcInvocation;
import org.apache.dubbo.rpc.rocketmq.codec.DecodeableRpcResult;
import org.apache.dubbo.rpc.rocketmq.codec.RocketMQCodecSupport;

public class RocketMQCodec
extends ExchangeCodec {
    public static final String NAME = "dubbo";
    public static final String DUBBO_VERSION = Version.getProtocolVersion();
    public static final byte RESPONSE_WITH_EXCEPTION = 0;
    public static final byte RESPONSE_VALUE = 1;
    public static final byte RESPONSE_NULL_VALUE = 2;
    public static final byte RESPONSE_WITH_EXCEPTION_WITH_ATTACHMENTS = 3;
    public static final byte RESPONSE_VALUE_WITH_ATTACHMENTS = 4;
    public static final byte RESPONSE_NULL_VALUE_WITH_ATTACHMENTS = 5;
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Logger log = LoggerFactory.getLogger(RocketMQCodec.class);
    private FrameworkModel frameworkModel;

    public RocketMQCodec(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    protected Object decodeBody(Channel channel, InputStream is, byte[] header) throws IOException {
        byte flag = header[2];
        byte proto = (byte)(flag & 0x1F);
        long id = Bytes.bytes2long((byte[])header, (int)4);
        if ((flag & 0xFFFFFF80) == 0) {
            Response res = new Response(id);
            if ((flag & 0x20) != 0) {
                res.setEvent(true);
            }
            byte status = header[3];
            res.setStatus(status);
            try {
                if (status == 20) {
                    Object data;
                    if (res.isEvent()) {
                        byte[] eventPayload = CodecSupport.getPayload((InputStream)is);
                        if (CodecSupport.isHeartBeat((byte[])eventPayload, (byte)proto)) {
                            data = null;
                        } else {
                            ObjectInput in = CodecSupport.deserialize((URL)channel.getUrl(), (InputStream)new ByteArrayInputStream(eventPayload), (byte)proto);
                            data = this.decodeEventData(channel, in, eventPayload);
                        }
                    } else {
                        DecodeableRpcResult result = new DecodeableRpcResult(channel, res, is, (Invocation)this.getRequestData(id), proto);
                        result.decode();
                        data = result;
                    }
                    res.setResult(data);
                } else {
                    ObjectInput in = CodecSupport.deserialize((URL)channel.getUrl(), (InputStream)is, (byte)proto);
                    res.setErrorMessage(in.readUTF());
                }
            }
            catch (Throwable t) {
                if (log.isWarnEnabled()) {
                    log.warn("Decode response failed: " + t.getMessage(), t);
                }
                res.setStatus((byte)90);
                res.setErrorMessage(StringUtils.toString((Throwable)t));
            }
            return res;
        }
        Request req = new Request(id);
        req.setVersion(Version.getProtocolVersion());
        req.setTwoWay((flag & 0x40) != 0);
        if ((flag & 0x20) != 0) {
            req.setEvent(true);
        }
        try {
            Object data;
            if (req.isEvent()) {
                byte[] eventPayload = CodecSupport.getPayload((InputStream)is);
                if (CodecSupport.isHeartBeat((byte[])eventPayload, (byte)proto)) {
                    data = null;
                } else {
                    ObjectInput in = CodecSupport.deserialize((URL)channel.getUrl(), (InputStream)new ByteArrayInputStream(eventPayload), (byte)proto);
                    data = this.decodeEventData(channel, in, eventPayload);
                }
            } else {
                DecodeableRpcInvocation inv = new DecodeableRpcInvocation(this.frameworkModel, channel, req, is, proto);
                inv.decode();
                data = inv;
            }
            req.setData(data);
        }
        catch (Throwable t) {
            if (log.isWarnEnabled()) {
                log.warn("Decode request failed: " + t.getMessage(), t);
            }
            req.setBroken(true);
            req.setData((Object)t);
        }
        return req;
    }

    protected void encodeRequestData(Channel channel, ObjectOutput out, Object data) throws IOException {
        this.encodeRequestData(channel, out, data, DUBBO_VERSION);
    }

    protected void encodeResponseData(Channel channel, ObjectOutput out, Object data) throws IOException {
        this.encodeResponseData(channel, out, data, DUBBO_VERSION);
    }

    protected void encodeRequestData(Channel channel, ObjectOutput out, Object data, String version) throws IOException {
        RpcInvocation inv = (RpcInvocation)data;
        out.writeUTF(version);
        String serviceName = inv.getAttachment("interface");
        if (serviceName == null) {
            serviceName = inv.getAttachment("path");
        }
        out.writeUTF(serviceName);
        out.writeUTF(inv.getAttachment("version"));
        out.writeUTF(inv.getMethodName());
        out.writeUTF(inv.getParameterTypesDesc());
        Object[] args = inv.getArguments();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                out.writeObject(args[i]);
            }
        }
        out.writeAttachments(inv.getObjectAttachments());
    }

    protected void encodeResponseData(Channel channel, ObjectOutput out, Object data, String version) throws IOException {
        Result result = (Result)data;
        boolean attach = Version.isSupportResponseAttachment((String)version);
        Throwable th = result.getException();
        if (th == null) {
            Object ret = result.getValue();
            if (ret == null) {
                out.writeByte(attach ? (byte)5 : 2);
            } else {
                out.writeByte(attach ? (byte)4 : 1);
                out.writeObject(ret);
            }
        } else {
            out.writeByte(attach ? (byte)3 : 0);
            out.writeThrowable((Object)th);
        }
        if (attach) {
            result.getObjectAttachments().put(NAME, Version.getProtocolVersion());
            out.writeAttachments(result.getObjectAttachments());
        }
    }

    protected Serialization getSerialization(Channel channel, Request req) {
        if (!(req.getData() instanceof Invocation)) {
            return super.getSerialization(channel, req);
        }
        return RocketMQCodecSupport.getRequestSerialization(channel.getUrl(), (Invocation)req.getData());
    }

    protected Serialization getSerialization(Channel channel, Response res) {
        if (!(res.getResult() instanceof AppResponse)) {
            return super.getSerialization(channel, res);
        }
        return RocketMQCodecSupport.getResponseSerialization(channel.getUrl(), (AppResponse)res.getResult());
    }
}

