/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.rocketmq;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;

public class RocketMQProtocolServer
implements ProtocolServer {
    private MessageListenerConcurrently messageListenerConcurrently;
    private DefaultMQProducer defaultMQProducer;
    private DefaultMQPushConsumer defaultMQPushConsumer;
    private String address;
    private String namespace;
    private URL url;
    private String model;
    private String inistanceName;
    private String producerGroup;
    private String consumerGroup;
    private boolean enableMsgTrace;
    private String customizedTraceTopic;
    private int sendMsgTimeout;
    private ExecutorService executor;

    public void setMessageListenerConcurrently(MessageListenerConcurrently messageListenerConcurrently) {
        this.messageListenerConcurrently = messageListenerConcurrently;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void close() {
        if (Objects.nonNull(this.defaultMQProducer)) {
            this.defaultMQProducer.shutdown();
        }
        if (Objects.nonNull(this.defaultMQPushConsumer)) {
            this.defaultMQPushConsumer.shutdown();
        }
    }

    public RemotingServer getRemotingServer() {
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    private void getConfig() {
        this.address = this.url.getAddress();
        this.enableMsgTrace = this.url.getParameter("enableMsgTrace", false);
        this.namespace = this.url.getParameter("namespace");
        this.customizedTraceTopic = this.url.getParameter("customizedTraceTopic");
        this.sendMsgTimeout = this.url.getParameter("timeout", 3000);
        this.inistanceName = this.url.getParameter("inistanceName", "default-" + System.currentTimeMillis());
        this.producerGroup = this.url.getParameter("producerGroup", "dubbo-roucketmq-producer-group");
        this.consumerGroup = this.url.getParameter("consumerGroup", "dubbo-roucketmq-consumer-group");
    }

    public synchronized void reset(URL url) {
        try {
            this.url = url;
            this.getConfig();
            DefaultMQProducer defaultMQProducer = new DefaultMQProducer(this.namespace, this.producerGroup, null, this.enableMsgTrace, this.customizedTraceTopic);
            defaultMQProducer.setNamesrvAddr(this.address);
            defaultMQProducer.setSendMsgTimeout(this.sendMsgTimeout);
            defaultMQProducer.setInstanceName("producer- " + this.inistanceName);
            defaultMQProducer.start();
            this.defaultMQProducer = defaultMQProducer;
            if (Objects.equals(this.model, "provider") || Objects.equals(this.model, "callbacks")) {
                this.createConsumer();
                this.executor = this.getSharedExecutorService(this.url);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ExecutorService getSharedExecutorService(URL url) {
        ExecutorRepository executorRepository = (ExecutorRepository)ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
        ExecutorService executor = executorRepository.getExecutor(url);
        if (executor == null) {
            executor = executorRepository.createExecutorIfAbsent(url);
        }
        return executor;
    }

    public synchronized void createConsumer() throws MQClientException {
        DefaultMQPushConsumer defaultMQPushConsumer = new DefaultMQPushConsumer(this.namespace, this.consumerGroup);
        defaultMQPushConsumer.setNamesrvAddr(this.address);
        defaultMQPushConsumer.setInstanceName("consumer- " + this.inistanceName);
        defaultMQPushConsumer.setConsumeThreadMin(16);
        defaultMQPushConsumer.setConsumeThreadMax(200);
        defaultMQPushConsumer.subscribe("dubbo_default_protocol_topic", defaultMQPushConsumer.buildMQClientId());
        defaultMQPushConsumer.setMessageListener((MessageListener)this.messageListenerConcurrently);
        defaultMQPushConsumer.start();
        this.defaultMQPushConsumer = defaultMQPushConsumer;
    }

    public DefaultMQProducer getDefaultMQProducer() {
        return this.defaultMQProducer;
    }

    public DefaultMQPushConsumer getDefaultMQPushConsumer() {
        return this.defaultMQPushConsumer;
    }

    public Map<String, Object> getAttributes() {
        return null;
    }

    public ExecutorService getExecutorService() {
        return this.executor;
    }
}

