/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.rocketmq;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.buffer.DynamicChannelBuffer;
import org.apache.dubbo.remoting.buffer.HeapChannelBuffer;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.exchange.support.DefaultFuture;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TimeoutCountDown;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.AbstractInvoker;
import org.apache.dubbo.rpc.rocketmq.RocketMQChannel;
import org.apache.dubbo.rpc.rocketmq.RocketMQProtocolConstant;
import org.apache.dubbo.rpc.rocketmq.RocketMQProtocolServer;
import org.apache.dubbo.rpc.rocketmq.codec.RocketMQCountCodec;
import org.apache.dubbo.rpc.support.RpcUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.RequestCallback;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;

public class RocketMQInvoker<T>
extends AbstractInvoker<T> {
    private final ReentrantLock destroyLock = new ReentrantLock();
    private final String version;
    private RocketMQCountCodec rocketMQCountCodec = new RocketMQCountCodec(FrameworkModel.defaultModel());
    private DefaultMQProducer defaultMQProducer;
    private String group;
    private MessageQueue messageQueue;
    private Channel channel = new RocketMQChannel();
    private String topic;
    private String groupModel;
    private Integer timeout;

    public RocketMQInvoker(Class<T> type, URL url, RocketMQProtocolServer rocketMQProtocolServer) {
        super(type, url);
        this.version = url.getParameter("version");
        this.group = url.getParameter("group");
        this.groupModel = url.getParameter("groupModel");
        this.defaultMQProducer = rocketMQProtocolServer.getDefaultMQProducer();
        this.topic = url.getParameter("topic");
        this.timeout = url.getParameter("timeout", 1000);
        Integer queueId = (Integer)url.getParameter("queueId", Integer.class, (Object)-1);
        if (queueId != -1) {
            this.messageQueue = new MessageQueue();
            this.messageQueue.setBrokerName(url.getParameter("brokerName"));
            this.messageQueue.setTopic(this.topic);
            this.messageQueue.setQueueId(queueId.intValue());
        }
    }

    protected Result doInvoke(Invocation invocation) throws Throwable {
        RpcInvocation inv = (RpcInvocation)invocation;
        String methodName = RpcUtils.getMethodName((Invocation)invocation);
        inv.setAttachment("path", this.getUrl().getPath());
        inv.setAttachment("version", this.version);
        try {
            RocketMQChannel channel = new RocketMQChannel();
            channel.setUrl(this.getUrl());
            RpcContext.getContext().setLocalAddress(RocketMQProtocolConstant.LOCAL_ADDRESS);
            boolean isOneway = RpcUtils.isOneway((URL)this.getUrl(), (Invocation)invocation);
            int timeout = this.calculateTimeout(invocation, methodName);
            invocation.put((Object)"timeout", (Object)timeout);
            Request request = new Request();
            request.setData((Object)inv);
            DynamicChannelBuffer buffer = new DynamicChannelBuffer(2048);
            this.rocketMQCountCodec.encode(channel, (ChannelBuffer)buffer, request);
            Message message = new Message(this.topic, null, buffer.array());
            if (!Objects.equals(this.groupModel, "topic")) {
                message.putUserProperty("generic", this.group);
                message.putUserProperty("version", this.version);
            }
            message.putUserProperty("send_address", NetUtils.getLocalHost());
            Long messageTimeout = System.currentTimeMillis() + (long)timeout;
            message.putUserProperty("timeout", messageTimeout.toString());
            message.putUserProperty("url_string", this.getUrl().toString());
            if (isOneway) {
                if (Objects.isNull(this.messageQueue)) {
                    this.defaultMQProducer.sendOneway(message);
                } else {
                    this.defaultMQProducer.sendOneway(message, this.messageQueue);
                }
                return AsyncRpcResult.newDefaultAsyncResult((Invocation)invocation);
            }
            CompletableFuture appResponseFuture = DefaultFuture.newFuture((Channel)channel, (Request)request, (int)timeout, (ExecutorService)this.getCallbackExecutor(this.getUrl(), (Invocation)inv)).thenApply(obj -> (AppResponse)obj);
            RequestCallback dubboRequestCallback = this.getRequestCallback();
            AsyncRpcResult result = new AsyncRpcResult(appResponseFuture, (Invocation)inv);
            if (Objects.isNull(this.messageQueue)) {
                this.defaultMQProducer.request(message, dubboRequestCallback, (long)timeout);
            } else {
                this.defaultMQProducer.request(message, this.messageQueue, dubboRequestCallback, (long)timeout);
            }
            return result;
        }
        catch (RemotingTooMuchRequestException e) {
            String exceptionInfo = "Invoke remote method timeout. method: " + invocation.getMethodName() + ", provider: " + this.getUrl() + ", cause: " + e.getMessage();
            logger.error(exceptionInfo, (Throwable)e);
            throw new RpcException(2, exceptionInfo, (Throwable)e);
        }
        catch (Exception e) {
            String exceptionInfo = "Failed to invoke remote method: " + invocation.getMethodName() + ", provider: " + this.getUrl() + ", cause: " + e.getMessage();
            logger.error(exceptionInfo, (Throwable)e);
            throw new RpcException(1, exceptionInfo, (Throwable)e);
        }
    }

    public RequestCallback getRequestCallback() {
        return new DubboRequestCallback();
    }

    private int calculateTimeout(Invocation invocation, String methodName) {
        Object countdown = RpcContext.getContext().get().get("timeout-countdown");
        int timeout = 1000;
        if (countdown == null) {
            timeout = (int)RpcUtils.getTimeout((URL)this.getUrl(), (String)methodName, (RpcContext)RpcContext.getContext(), (long)this.timeout.intValue());
            if (this.getUrl().getParameter("enable-timeout-countdown", false)) {
                invocation.setObjectAttachment("_TO", (Object)timeout);
            }
        } else {
            TimeoutCountDown timeoutCountDown = (TimeoutCountDown)countdown;
            timeout = (int)timeoutCountDown.timeRemaining(TimeUnit.MILLISECONDS);
            invocation.setObjectAttachment("_TO", (Object)timeout);
        }
        return timeout;
    }

    public boolean isAvailable() {
        return super.isAvailable();
    }

    public void destroy() {
        if (super.isDestroyed()) {
            return;
        }
        try {
            this.destroyLock.lock();
            if (super.isDestroyed()) {
                return;
            }
            this.defaultMQProducer.shutdown();
        }
        finally {
            this.destroyLock.unlock();
        }
    }

    class DubboRequestCallback
    implements RequestCallback {
        DubboRequestCallback() {
        }

        public void onSuccess(Message message) {
            try {
                RpcContext.getContext().setRemoteAddress(message.getUserProperty("send_address"), 9876);
                String urlString = message.getUserProperty("url_string");
                URL url = URL.valueOf((String)urlString);
                RocketMQChannel channel = new RocketMQChannel();
                channel.setRemoteAddress(RpcContext.getContext().getRemoteAddress());
                channel.setUrl(url);
                HeapChannelBuffer heapChannelBuffer = new HeapChannelBuffer(message.getBody());
                Object object = RocketMQInvoker.this.rocketMQCountCodec.decode(channel, (ChannelBuffer)heapChannelBuffer);
                Response response = (Response)object;
                DefaultFuture.received((Channel)channel, (Response)response);
            }
            catch (Exception e) {
                this.onException(e);
            }
        }

        public void onException(Throwable e) {
            Response response = new Response();
            response.setErrorMessage(e.getMessage());
            response.setStatus((byte)70);
            DefaultFuture.received((Channel)RocketMQInvoker.this.channel, (Response)response);
            logger.error(e.getMessage(), e);
        }
    }
}

