/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.rocketmq;

import java.util.Map;
import java.util.Objects;
import java.util.zip.CRC32;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.protocol.AbstractExporter;

public class RocketMQExporter<T>
extends AbstractExporter<T> {
    private static final String DEFAULT_PARAM_VALUE = "";
    private static final String NAME_SEPARATOR = "_";
    private final String key;
    private final Map<String, Exporter<?>> exporterMap;

    public RocketMQExporter(Invoker<T> invoker, URL url, Map<String, Exporter<?>> exporterMap) {
        super(invoker);
        this.key = this.toValue(url);
        this.exporterMap = exporterMap;
        this.exporterMap.put(this.key, (Exporter<?>)this);
    }

    public void afterUnExport() {
        this.exporterMap.remove(this.key, (Object)this);
    }

    public String getKey() {
        return this.key;
    }

    private String toValue(URL url) {
        String serviceInterface = url.getParameter("interface");
        String version = url.getParameter("version", DEFAULT_PARAM_VALUE);
        String group = url.getParameter("group", DEFAULT_PARAM_VALUE);
        String value = null;
        value = Objects.equals(url.getParameter("groupModel"), "topic") ? "providers_" + serviceInterface + NAME_SEPARATOR + version + NAME_SEPARATOR + group : "providers_" + serviceInterface;
        CRC32 crc32 = new CRC32();
        crc32.update(value.getBytes());
        value = value.replace(".", "-") + NAME_SEPARATOR + Long.toString(crc32.getValue());
        return value;
    }
}

