/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.rocketmq;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.buffer.DynamicChannelBuffer;
import org.apache.dubbo.rpc.rocketmq.RocketMQProtocolConstant;
import org.apache.dubbo.rpc.rocketmq.codec.RocketMQCountCodec;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.utils.MessageUtil;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;

public class RocketMQChannel
implements Channel {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private RocketMQCountCodec rocketmqCountCodec;
    private DefaultMQProducer defaultMQProducer;
    private MessageExt messageExt;
    private String urlString;
    private URL url;
    private InetSocketAddress remoteAddress;

    public void setRocketMQCountCodec(RocketMQCountCodec rocketmqCountCodec) {
        this.rocketmqCountCodec = rocketmqCountCodec;
    }

    public void setDefaultMQProducer(DefaultMQProducer defaultMQProducer) {
        this.defaultMQProducer = defaultMQProducer;
    }

    public void setMessageExt(MessageExt messageExt) {
        this.messageExt = messageExt;
    }

    public void setUrlString(String urlString) {
        this.urlString = urlString;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public ChannelHandler getChannelHandler() {
        return null;
    }

    public InetSocketAddress getLocalAddress() {
        return RocketMQProtocolConstant.LOCAL_ADDRESS;
    }

    public void send(Object message) throws RemotingException {
        this.send(message, false);
    }

    public void send(Object message, boolean sent) throws RemotingException {
        DynamicChannelBuffer buffer = new DynamicChannelBuffer(2048);
        try {
            this.rocketmqCountCodec.encode(this, (ChannelBuffer)buffer, message);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        try {
            Message newMessage = MessageUtil.createReplyMessage((Message)this.messageExt, (byte[])buffer.array());
            newMessage.putUserProperty("send_address", RocketMQProtocolConstant.LOCAL_ADDRESS.getHostString());
            newMessage.putUserProperty("url_string", this.urlString);
            SendResult sendResult = this.defaultMQProducer.send(newMessage, 3000L);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("send result is : %s", sendResult));
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
    }

    public void close() {
    }

    public void close(int timeout) {
    }

    public void startClose() {
    }

    public boolean isClosed() {
        return false;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public boolean isConnected() {
        return true;
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }
}

