/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.injvm;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.threadlocal.InternalThreadLocalMap;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.url.component.DubboServiceAddressURL;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.FutureContext;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceModel;
import org.apache.dubbo.rpc.protocol.AbstractInvoker;
import org.apache.dubbo.rpc.protocol.injvm.InjvmExporter;
import org.apache.dubbo.rpc.protocol.injvm.InjvmProtocol;
import org.apache.dubbo.rpc.protocol.injvm.ParamDeepCopyUtil;
import org.apache.dubbo.rpc.support.RpcUtils;

public class InjvmInvoker<T>
extends AbstractInvoker<T> {
    private final String key;
    private final Map<String, Exporter<?>> exporterMap;
    private volatile Exporter<?> exporter = null;
    private volatile URL consumerUrl = null;
    private final ExecutorRepository executorRepository;
    private final ParamDeepCopyUtil paramDeepCopyUtil;
    private final boolean shouldIgnoreSameModule;
    private static final boolean setFutureWhenSync = Boolean.parseBoolean(SystemPropertyConfigUtils.getSystemProperty((String)"future.sync.set", (String)"true"));

    InjvmInvoker(Class<T> type, URL url, String key, Map<String, Exporter<?>> exporterMap) {
        super(type, url);
        this.key = key;
        this.exporterMap = exporterMap;
        this.executorRepository = ExecutorRepository.getInstance((ApplicationModel)url.getOrDefaultApplicationModel());
        this.paramDeepCopyUtil = (ParamDeepCopyUtil)url.getOrDefaultFrameworkModel().getExtensionLoader(ParamDeepCopyUtil.class).getExtension(url.getParameter("injvm-copy-util", "default"));
        this.shouldIgnoreSameModule = url.getParameter("injvm.ignore.same-module", false);
    }

    public boolean isAvailable() {
        InjvmExporter exporter = (InjvmExporter)this.exporterMap.get(this.key);
        if (exporter == null) {
            return false;
        }
        return super.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result doInvoke(Invocation invocation) throws Throwable {
        Result result;
        int timeout;
        Invoker invoker;
        URL serverURL;
        boolean serverHasToken;
        if (this.exporter == null) {
            this.exporter = InjvmProtocol.getExporter(this.exporterMap, this.getUrl());
            if (this.exporter == null) {
                throw new RpcException("Service [" + this.key + "] not found.");
            }
        }
        if (serverHasToken = (serverURL = (invoker = this.exporter.getInvoker()).getUrl()).hasParameter("token")) {
            invocation.setAttachment("token", serverURL.getParameter("token"));
        }
        if (this.consumerUrl == null) {
            this.consumerUrl = new DubboServiceAddressURL(serverURL.getUrlAddress(), serverURL.getUrlParam(), this.getUrl(), null);
        }
        if ((timeout = RpcUtils.calculateTimeout((URL)this.consumerUrl, (Invocation)invocation, (String)RpcUtils.getMethodName((Invocation)invocation), (long)1000L)) <= 0) {
            return AsyncRpcResult.newDefaultAsyncResult((Throwable)new RpcException(8, "No time left for making the following call: " + invocation.getServiceName() + "." + RpcUtils.getMethodName((Invocation)invocation) + ", terminate directly."), (Invocation)invocation);
        }
        invocation.setAttachment("timeout", String.valueOf(timeout));
        String desc = ReflectUtils.getDesc((Class[])invocation.getParameterTypes());
        Invocation copiedInvocation = this.recreateInvocation(invocation, invoker, desc);
        if (this.isAsync(invoker.getUrl(), this.getUrl())) {
            ((RpcInvocation)copiedInvocation).setInvokeMode(InvokeMode.ASYNC);
            ExecutorService executor = this.executorRepository.createExecutorIfAbsent(ExecutorUtil.setThreadName((URL)this.getUrl(), (String)"DubboServerHandler"));
            CompletableFuture<AppResponse> appResponseFuture = CompletableFuture.supplyAsync(() -> {
                InternalThreadLocalMap originTL = InternalThreadLocalMap.getAndRemove();
                try {
                    RpcContext.getServiceContext().setRemoteAddress("127.0.0.1", 0);
                    RpcContext.getServiceContext().setRemoteApplicationName(this.getUrl().getApplication());
                    Result result = invoker.invoke(copiedInvocation);
                    if (result.hasException()) {
                        AppResponse appResponse = new AppResponse(result.getException());
                        appResponse.setObjectAttachments(new HashMap(result.getObjectAttachments()));
                        AppResponse appResponse2 = appResponse;
                        return appResponse2;
                    }
                    this.rebuildValue(invocation, invoker, result);
                    AppResponse appResponse = new AppResponse(result.getValue());
                    appResponse.setObjectAttachments(new HashMap(result.getObjectAttachments()));
                    AppResponse appResponse3 = appResponse;
                    return appResponse3;
                }
                finally {
                    InternalThreadLocalMap.set((InternalThreadLocalMap)originTL);
                }
            }, executor);
            if (setFutureWhenSync || ((RpcInvocation)invocation).getInvokeMode() != InvokeMode.SYNC) {
                FutureContext.getContext().setCompatibleFuture(appResponseFuture);
            }
            AsyncRpcResult result2 = new AsyncRpcResult(appResponseFuture, copiedInvocation);
            result2.setExecutor((Executor)executor);
            return result2;
        }
        InternalThreadLocalMap originTL = InternalThreadLocalMap.getAndRemove();
        try {
            RpcContext.getServiceContext().setRemoteAddress("127.0.0.1", 0);
            RpcContext.getServiceContext().setRemoteApplicationName(this.getUrl().getApplication());
            result = invoker.invoke(copiedInvocation);
        }
        finally {
            InternalThreadLocalMap.set((InternalThreadLocalMap)originTL);
        }
        CompletableFuture<AppResponse> future = new CompletableFuture<AppResponse>();
        AppResponse rpcResult = new AppResponse(copiedInvocation);
        if (result instanceof AsyncRpcResult) {
            result.whenCompleteWithContext((r, t) -> {
                if (t != null) {
                    rpcResult.setException(t);
                } else if (r.hasException()) {
                    rpcResult.setException(r.getException());
                } else {
                    Object rebuildValue = this.rebuildValue(invocation, invoker, r.getValue());
                    rpcResult.setValue(rebuildValue);
                }
                rpcResult.setObjectAttachments(new HashMap(r.getObjectAttachments()));
                future.complete(rpcResult);
            });
        } else {
            if (result.hasException()) {
                rpcResult.setException(result.getException());
            } else {
                Object rebuildValue = this.rebuildValue(invocation, invoker, result.getValue());
                rpcResult.setValue(rebuildValue);
            }
            rpcResult.setObjectAttachments(new HashMap(result.getObjectAttachments()));
            future.complete(rpcResult);
        }
        return new AsyncRpcResult(future, invocation);
    }

    private Class<?> getReturnType(ServiceModel consumerServiceModel, String methodName, String desc) {
        Object[] returnTypes;
        MethodDescriptor consumerMethod = consumerServiceModel.getServiceModel().getMethod(methodName, desc);
        if (consumerMethod != null && ArrayUtils.isNotEmpty((Object[])(returnTypes = consumerMethod.getReturnTypes()))) {
            return (Class)returnTypes[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Invocation recreateInvocation(Invocation invocation, Invoker<?> invoker, String desc) {
        ClassLoader originClassLoader = Thread.currentThread().getContextClassLoader();
        ServiceModel providerServiceModel = invoker.getUrl().getServiceModel();
        if (providerServiceModel == null) {
            return invocation;
        }
        String methodName = invocation.getMethodName();
        if (this.isSkipCopy(invocation, invoker)) {
            RpcInvocation copiedInvocation = new RpcInvocation(invocation.getTargetServiceUniqueName(), providerServiceModel, methodName, invocation.getServiceName(), invocation.getProtocolServiceKey(), invocation.getParameterTypes(), invocation.getArguments(), invocation.copyObjectAttachments(), invocation.getInvoker(), new HashMap(), invocation instanceof RpcInvocation ? ((RpcInvocation)invocation).getInvokeMode() : null);
            copiedInvocation.setInvoker(invoker);
            return copiedInvocation;
        }
        MethodDescriptor providerMethod = providerServiceModel.getServiceModel().getMethod(methodName, desc);
        Object[] realArgument = null;
        if (providerMethod != null) {
            Class[] pts = providerMethod.getParameterClasses();
            Object[] args = invocation.getArguments();
            Thread.currentThread().setContextClassLoader(providerServiceModel.getClassLoader());
            try {
                if (pts != null && args != null && pts.length == args.length) {
                    realArgument = new Object[pts.length];
                    for (int i = 0; i < pts.length; ++i) {
                        realArgument[i] = this.paramDeepCopyUtil.copy(this.consumerUrl, args[i], pts[i]);
                    }
                }
                if (realArgument == null) {
                    realArgument = args;
                }
                RpcInvocation copiedInvocation = new RpcInvocation(invocation.getTargetServiceUniqueName(), providerServiceModel, methodName, invocation.getServiceName(), invocation.getProtocolServiceKey(), pts, realArgument, invocation.copyObjectAttachments(), invocation.getInvoker(), new HashMap(), invocation instanceof RpcInvocation ? ((RpcInvocation)invocation).getInvokeMode() : null);
                copiedInvocation.setInvoker(invoker);
                RpcInvocation rpcInvocation = copiedInvocation;
                return rpcInvocation;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originClassLoader);
            }
        }
        return invocation;
    }

    private boolean isSkipCopy(Invocation invocation, Invoker<?> invoker) {
        ServiceModel providerServiceModel = invoker.getUrl().getServiceModel();
        if (providerServiceModel == null) {
            return true;
        }
        String methodName = invocation.getMethodName();
        ServiceModel consumerServiceModel = invocation.getServiceModel();
        boolean shouldSkip = this.shouldIgnoreSameModule && consumerServiceModel != null && Objects.equals(providerServiceModel.getModuleModel(), consumerServiceModel.getModuleModel());
        return "$invoke".equals(methodName) || "$invokeAsync".equals(methodName) || shouldSkip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object rebuildValue(Invocation invocation, Invoker<?> invoker, Object originValue) {
        if (this.isSkipCopy(invocation, invoker)) {
            return originValue;
        }
        Object value = originValue;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader consumerClassLoader = contextClassLoader;
            ServiceModel serviceModel = this.getUrl().getServiceModel();
            if (Objects.nonNull(serviceModel) && serviceModel instanceof ConsumerModel) {
                consumerClassLoader = serviceModel.getClassLoader();
            }
            if (Objects.nonNull(consumerClassLoader)) {
                Thread.currentThread().setContextClassLoader(consumerClassLoader);
                Type[] returnTypes = RpcUtils.getReturnTypes((Invocation)invocation);
                if (returnTypes == null) {
                    Object object = originValue;
                    return object;
                }
                if (returnTypes.length == 1) {
                    value = this.paramDeepCopyUtil.copy(this.consumerUrl, originValue, (Class)returnTypes[0]);
                } else if (returnTypes.length == 2) {
                    value = this.paramDeepCopyUtil.copy(this.consumerUrl, originValue, (Class)returnTypes[0], returnTypes[1]);
                }
            }
            Object object = value;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private boolean isAsync(URL remoteUrl, URL localUrl) {
        if (localUrl.hasParameter("async")) {
            return localUrl.getParameter("async", false);
        }
        return remoteUrl.getParameter("async", false);
    }
}

