/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.lang.reflect.ParameterizedType;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ReflectionMethodDescriptor;
import org.apache.dubbo.rpc.model.StubMethodDescriptor;

public class MethodMetadata {
    private final Class<?>[] actualRequestTypes;
    private final Class<?> actualResponseType;

    private MethodMetadata(Class<?>[] actualRequestTypes, Class<?> actualResponseType) {
        this.actualRequestTypes = actualRequestTypes;
        this.actualResponseType = actualResponseType;
    }

    public Class<?>[] getActualRequestTypes() {
        return this.actualRequestTypes;
    }

    public Class<?> getActualResponseType() {
        return this.actualResponseType;
    }

    public static MethodMetadata fromMethodDescriptor(MethodDescriptor method) {
        if (method instanceof ReflectionMethodDescriptor) {
            return MethodMetadata.doResolveReflection((ReflectionMethodDescriptor)method);
        }
        if (method instanceof StubMethodDescriptor) {
            return MethodMetadata.doResolveStub((StubMethodDescriptor)method);
        }
        throw new IllegalStateException("Can not reach here");
    }

    private static MethodMetadata doResolveStub(StubMethodDescriptor method) {
        Class[] actualRequestTypes = method.getParameterClasses();
        Class actualResponseType = method.getReturnClass();
        return new MethodMetadata(actualRequestTypes, actualResponseType);
    }

    private static MethodMetadata doResolveReflection(ReflectionMethodDescriptor method) {
        switch (method.getRpcType()) {
            case CLIENT_STREAM: 
            case BI_STREAM: {
                Class[] actualRequestTypes = new Class[]{(Class)((ParameterizedType)method.getMethod().getGenericReturnType()).getActualTypeArguments()[0]};
                Class actualResponseType = (Class)((ParameterizedType)method.getMethod().getGenericParameterTypes()[0]).getActualTypeArguments()[0];
                return new MethodMetadata(actualRequestTypes, actualResponseType);
            }
            case SERVER_STREAM: {
                Class[] actualRequestTypes = new Class[]{method.getMethod().getParameterTypes()[0]};
                Class actualResponseType = (Class)((ParameterizedType)method.getMethod().getGenericParameterTypes()[1]).getActualTypeArguments()[0];
                return new MethodMetadata(actualRequestTypes, actualResponseType);
            }
            case UNARY: {
                Class[] actualRequestTypes = method.getParameterClasses();
                Class actualResponseType = (Class)method.getReturnTypes()[0];
                return new MethodMetadata(actualRequestTypes, actualResponseType);
            }
        }
        throw new IllegalStateException("Can not reach here");
    }
}

