/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.remoting.http12.ErrorResponse;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.HttpUtils;
import org.apache.dubbo.remoting.http12.ServerHttpChannelObserver;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;

public abstract class AbstractServerHttpChannelObserver<H extends HttpChannel>
implements ServerHttpChannelObserver<H> {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(AbstractServerHttpChannelObserver.class);
    private final H httpChannel;
    private List<BiConsumer<HttpHeaders, Throwable>> headersCustomizers;
    private List<BiConsumer<HttpHeaders, Throwable>> trailersCustomizers;
    private Function<Throwable, ?> exceptionCustomizer;
    private HttpMessageEncoder responseEncoder;
    private boolean headerSent;
    private boolean completed;
    private boolean closed;

    protected AbstractServerHttpChannelObserver(H httpChannel) {
        this.httpChannel = httpChannel;
    }

    @Override
    public H getHttpChannel() {
        return this.httpChannel;
    }

    @Override
    public void addHeadersCustomizer(BiConsumer<HttpHeaders, Throwable> headersCustomizer) {
        if (this.headersCustomizers == null) {
            this.headersCustomizers = new ArrayList<BiConsumer<HttpHeaders, Throwable>>();
        }
        this.headersCustomizers.add(headersCustomizer);
    }

    @Override
    public void addTrailersCustomizer(BiConsumer<HttpHeaders, Throwable> trailersCustomizer) {
        if (this.trailersCustomizers == null) {
            this.trailersCustomizers = new ArrayList<BiConsumer<HttpHeaders, Throwable>>();
        }
        this.trailersCustomizers.add(trailersCustomizer);
    }

    @Override
    public void setExceptionCustomizer(Function<Throwable, ?> exceptionCustomizer) {
        this.exceptionCustomizer = exceptionCustomizer;
    }

    public HttpMessageEncoder getResponseEncoder() {
        return this.responseEncoder;
    }

    public void setResponseEncoder(HttpMessageEncoder responseEncoder) {
        this.responseEncoder = responseEncoder;
    }

    public final void onNext(Object data) {
        if (this.closed) {
            return;
        }
        try {
            this.doOnNext(data);
        }
        catch (Throwable t) {
            LOGGER.warn("99-0", "", "", "Error while doOnNext", t);
            this.onError(t);
        }
    }

    public final void onError(Throwable throwable) {
        if (this.closed) {
            return;
        }
        try {
            throwable = this.customizeError(throwable);
            if (throwable == null) {
                return;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("99-0", "", "", "Error while handleError, original error: " + throwable, t);
            throwable = t;
        }
        try {
            this.doOnError(throwable);
        }
        catch (Throwable t) {
            LOGGER.warn("99-0", "", "", "Error while doOnError, original error: " + throwable, t);
            throwable = t;
        }
        this.onCompleted(throwable);
    }

    public final void onCompleted() {
        if (this.closed) {
            return;
        }
        this.onCompleted(null);
    }

    protected void doOnNext(Object data) throws Throwable {
        int statusCode = this.resolveStatusCode(data);
        if (!this.headerSent) {
            this.sendMetadata(this.buildMetadata(statusCode, data, null, HttpOutputMessage.EMPTY_MESSAGE));
        }
        this.sendMessage(this.buildMessage(statusCode, data));
    }

    protected final int resolveStatusCode(Object data) {
        int status;
        if (data instanceof HttpResult && (status = ((HttpResult)data).getStatus()) >= 100) {
            return status;
        }
        return HttpStatus.OK.getCode();
    }

    protected final HttpMetadata buildMetadata(int statusCode, Object data, Throwable throwable, HttpOutputMessage message) {
        HttpResult result;
        HttpMetadata metadata = this.encodeHttpMetadata(message == null);
        HttpHeaders headers = metadata.headers();
        headers.set(HttpHeaderNames.STATUS.getKey(), HttpUtils.toStatusString(statusCode));
        if (message != null) {
            headers.set(HttpHeaderNames.CONTENT_TYPE.getKey(), this.responseEncoder.contentType());
        }
        if (data instanceof HttpResult && (result = (HttpResult)data).getHeaders() != null) {
            headers.add(result.getHeaders());
        }
        this.customizeHeaders(headers, throwable, message);
        return metadata;
    }

    protected abstract HttpMetadata encodeHttpMetadata(boolean var1);

    protected void customizeHeaders(HttpHeaders headers, Throwable throwable, HttpOutputMessage message) {
        List<BiConsumer<HttpHeaders, Throwable>> headersCustomizers = this.headersCustomizers;
        if (headersCustomizers != null) {
            int size = headersCustomizers.size();
            for (int i = 0; i < size; ++i) {
                headersCustomizers.get(i).accept(headers, throwable);
            }
        }
    }

    protected final void sendMetadata(HttpMetadata metadata) {
        this.getHttpChannel().writeHeader(metadata);
        this.headerSent = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Http response headers sent: " + metadata.headers());
        }
    }

    protected final HttpOutputMessage buildMessage(int statusCode, Object data) throws Throwable {
        if (statusCode < 200 || statusCode == 204 || statusCode == 304) {
            return null;
        }
        if (data instanceof HttpResult) {
            data = ((HttpResult)data).getBody();
        }
        if (data == null && statusCode != 200) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            try {
                LOGGER.debug("Http response body sent: '{}' by [{}]", new Object[]{JsonUtils.toJson((Object)data), this.httpChannel});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        HttpOutputMessage message = this.encodeHttpOutputMessage(data);
        try {
            this.preOutputMessage(message);
            this.responseEncoder.encode(message.getBody(), data);
        }
        catch (Throwable t) {
            message.close();
            throw t;
        }
        return message;
    }

    protected HttpOutputMessage encodeHttpOutputMessage(Object data) {
        return this.getHttpChannel().newOutputMessage();
    }

    protected final void sendMessage(HttpOutputMessage message) throws Throwable {
        if (message == null) {
            return;
        }
        this.getHttpChannel().writeMessage(message);
        this.postOutputMessage(message);
    }

    protected void preOutputMessage(HttpOutputMessage message) throws Throwable {
    }

    protected void postOutputMessage(HttpOutputMessage message) throws Throwable {
    }

    protected Throwable customizeError(Throwable throwable) {
        if (this.exceptionCustomizer == null) {
            return throwable;
        }
        Object result = this.exceptionCustomizer.apply(throwable);
        if (result == null) {
            return throwable;
        }
        if (result instanceof Throwable) {
            return (Throwable)result;
        }
        this.onNext(result);
        return null;
    }

    protected void doOnError(Throwable throwable) throws Throwable {
        int statusCode = this.resolveErrorStatusCode(throwable);
        ErrorResponse data = this.buildErrorResponse(statusCode, throwable);
        if (!this.headerSent) {
            this.sendMetadata(this.buildMetadata(statusCode, data, throwable, HttpOutputMessage.EMPTY_MESSAGE));
        }
        this.sendMessage(this.buildMessage(statusCode, data));
    }

    protected final int resolveErrorStatusCode(Throwable throwable) {
        if (throwable == null) {
            return HttpStatus.OK.getCode();
        }
        if (throwable instanceof HttpStatusException) {
            return ((HttpStatusException)throwable).getStatusCode();
        }
        return HttpStatus.INTERNAL_SERVER_ERROR.getCode();
    }

    protected final ErrorResponse buildErrorResponse(int statusCode, Throwable throwable) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setStatus(HttpUtils.toStatusString(statusCode));
        if (throwable instanceof HttpStatusException) {
            errorResponse.setMessage(((HttpStatusException)throwable).getDisplayMessage());
        } else {
            errorResponse.setMessage(this.getDisplayMessage(throwable));
        }
        return errorResponse;
    }

    protected String getDisplayMessage(Throwable throwable) {
        return "Internal Server Error";
    }

    protected void onCompleted(Throwable throwable) {
        if (this.completed) {
            return;
        }
        this.doOnCompleted(throwable);
        this.completed = true;
    }

    protected void doOnCompleted(Throwable throwable) {
        HttpMetadata trailerMetadata = this.encodeTrailers(throwable);
        if (trailerMetadata == null) {
            return;
        }
        HttpHeaders headers = trailerMetadata.headers();
        if (!this.headerSent) {
            headers.set(HttpHeaderNames.STATUS.getKey(), HttpUtils.toStatusString(this.resolveErrorStatusCode(throwable)));
            headers.set(HttpHeaderNames.CONTENT_TYPE.getKey(), this.getContentType());
        }
        this.customizeTrailers(headers, throwable);
        this.getHttpChannel().writeHeader(trailerMetadata);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Http response trailers sent: " + headers);
        }
    }

    protected HttpMetadata encodeTrailers(Throwable throwable) {
        return null;
    }

    protected String getContentType() {
        return this.responseEncoder.contentType();
    }

    protected void customizeTrailers(HttpHeaders headers, Throwable throwable) {
        List<BiConsumer<HttpHeaders, Throwable>> trailersCustomizers = this.trailersCustomizers;
        if (trailersCustomizers != null) {
            int size = trailersCustomizers.size();
            for (int i = 0; i < size; ++i) {
                trailersCustomizers.get(i).accept(headers, throwable);
            }
        }
    }

    @Override
    public void close() {
        this.closed();
    }

    protected final void closed() {
        this.closed = true;
    }
}

