/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http.support;

import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.dubbo.common.Parameters;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.http.HttpHandler;
import org.apache.dubbo.remoting.http.HttpServer;

public abstract class AbstractHttpServer
implements HttpServer {
    private final URL url;
    private final HttpHandler handler;
    private volatile boolean closed;

    public AbstractHttpServer(URL url, HttpHandler handler) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        this.url = url;
        this.handler = handler;
    }

    @Override
    public HttpHandler getHttpHandler() {
        return this.handler;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public void reset(URL url) {
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.url.toInetSocketAddress();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void close(int timeout) {
        this.close();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public boolean canHandleIdle() {
        return false;
    }

    public Collection<Channel> getChannels() {
        return null;
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        return null;
    }

    public void reset(Parameters parameters) {
    }

    public ChannelHandler getChannelHandler() {
        return null;
    }

    public void send(Object message) throws RemotingException {
    }

    public void send(Object message, boolean sent) throws RemotingException {
    }

    public void startClose() {
    }
}

