/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.event.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.event.ConditionalEventListener;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.registry.client.RegistryClusterIdentifier;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.RemoteMetadataServiceImpl;

public class ServiceInstancesChangedListener
implements ConditionalEventListener<ServiceInstancesChangedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstancesChangedListener.class);
    private final Set<String> serviceNames;
    private final ServiceDiscovery serviceDiscovery;
    private final String registryId;
    private URL url;
    private Map<String, Set<NotifyListener>> listeners;
    private Map<String, List<ServiceInstance>> allInstances;
    private Map<String, List<URL>> serviceUrls;
    private Map<String, MetadataInfo> revisionToMetadata;

    public ServiceInstancesChangedListener(Set<String> serviceNames, ServiceDiscovery serviceDiscovery) {
        this.serviceNames = serviceNames;
        this.serviceDiscovery = serviceDiscovery;
        this.registryId = serviceDiscovery.getUrl().getParameter("id");
        this.listeners = new HashMap<String, Set<NotifyListener>>();
        this.allInstances = new HashMap<String, List<ServiceInstance>>();
        this.serviceUrls = new HashMap<String, List<URL>>();
        this.revisionToMetadata = new HashMap<String, MetadataInfo>();
    }

    public synchronized void onEvent(ServiceInstancesChangedEvent event) {
        logger.info("Received instance notification, serviceName: " + event.getServiceName() + ", instances: " + event.getServiceInstances().size());
        String appName = event.getServiceName();
        this.allInstances.put(appName, event.getServiceInstances());
        if (logger.isDebugEnabled()) {
            logger.debug(event.getServiceInstances().toString());
        }
        HashMap<String, List> revisionToInstances = new HashMap<String, List>();
        HashMap<String, Set<String>> localServiceToRevisions = new HashMap<String, Set<String>>();
        HashMap revisionsToUrls = new HashMap();
        HashMap<String, List<URL>> tmpServiceUrls = new HashMap<String, List<URL>>();
        for (Map.Entry<String, List<ServiceInstance>> entry : this.allInstances.entrySet()) {
            List<ServiceInstance> instances = entry.getValue();
            for (ServiceInstance instance : instances) {
                String revision = ServiceInstanceMetadataUtils.getExportedServicesRevision(instance);
                if (MetadataInfo.DEFAULT_REVISION.equals(revision)) {
                    logger.info("Find instance without valid service metadata: " + instance.getAddress());
                    continue;
                }
                List subInstances = revisionToInstances.computeIfAbsent(revision, r -> new LinkedList());
                subInstances.add(instance);
                MetadataInfo metadata = this.revisionToMetadata.get(revision);
                if (metadata == null) {
                    metadata = this.getMetadataInfo(instance);
                    logger.info("MetadataInfo for instance " + instance.getAddress() + "?revision=" + revision + " is " + metadata);
                    if (metadata != null) {
                        this.revisionToMetadata.put(revision, metadata);
                    }
                }
                if (metadata == null) continue;
                this.parseMetadata(revision, metadata, localServiceToRevisions);
                ((DefaultServiceInstance)instance).setServiceMetadata(metadata);
            }
            localServiceToRevisions.forEach((serviceKey, revisions) -> {
                ArrayList<InstanceAddressURL> urls = (ArrayList<InstanceAddressURL>)revisionsToUrls.get(revisions);
                if (urls != null) {
                    tmpServiceUrls.put((String)serviceKey, (List<URL>)urls);
                } else {
                    urls = new ArrayList<InstanceAddressURL>();
                    for (String r : revisions) {
                        for (ServiceInstance i : (List)revisionToInstances.get(r)) {
                            urls.add(i.toURL());
                        }
                    }
                    revisionsToUrls.put(revisions, urls);
                    tmpServiceUrls.put((String)serviceKey, (List<URL>)urls);
                }
            });
        }
        this.serviceUrls = tmpServiceUrls;
        this.notifyAddressChanged();
    }

    private Map<String, Set<String>> parseMetadata(String revision, MetadataInfo metadata, Map<String, Set<String>> localServiceToRevisions) {
        Map serviceInfos = metadata.getServices();
        for (Map.Entry entry : serviceInfos.entrySet()) {
            Set set = localServiceToRevisions.computeIfAbsent((String)entry.getKey(), k -> new TreeSet());
            set.add(revision);
        }
        return localServiceToRevisions;
    }

    private MetadataInfo getMetadataInfo(ServiceInstance instance) {
        String metadataType = ServiceInstanceMetadataUtils.getMetadataStorageType(instance);
        instance.getExtendParams().putIfAbsent("REGISTRY_CLUSTER", RegistryClusterIdentifier.getExtension(this.url).consumerKey(this.url));
        MetadataInfo metadataInfo = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Instance " + instance.getAddress() + " is using metadata type " + metadataType);
            }
            if ("remote".equals(metadataType)) {
                RemoteMetadataServiceImpl remoteMetadataService = MetadataUtils.getRemoteMetadataService();
                metadataInfo = remoteMetadataService.getMetadata(instance);
            } else {
                MetadataService metadataServiceProxy = MetadataUtils.getMetadataServiceProxy(instance, this.serviceDiscovery);
                metadataInfo = metadataServiceProxy.getMetadataInfo(ServiceInstanceMetadataUtils.getExportedServicesRevision(instance));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Metadata " + metadataInfo.toString());
            }
        }
        catch (Exception e) {
            logger.error("Failed to load service metadata, metadata type is " + metadataType, (Throwable)e);
        }
        return metadataInfo;
    }

    private void notifyAddressChanged() {
        this.listeners.forEach((key, notifyListeners) -> notifyListeners.forEach(notifyListener -> notifyListener.notify(this.toUrlsWithEmpty(this.serviceUrls.get(key)))));
    }

    private List<URL> toUrlsWithEmpty(List<URL> urls) {
        if (urls == null) {
            urls = Collections.emptyList();
        }
        return urls;
    }

    public void addListener(String serviceKey, NotifyListener listener) {
        this.listeners.computeIfAbsent(serviceKey, k -> new HashSet()).add(listener);
    }

    public void removeListener(String serviceKey) {
        this.listeners.remove(serviceKey);
        if (this.listeners.isEmpty()) {
            this.serviceDiscovery.removeServiceInstancesChangedListener(this);
        }
    }

    public List<URL> getUrls(String serviceKey) {
        return this.toUrlsWithEmpty(this.serviceUrls.get(serviceKey));
    }

    public final Set<String> getServiceNames() {
        return this.serviceNames;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public final boolean accept(ServiceInstancesChangedEvent event) {
        return this.serviceNames.contains(event.getServiceName());
    }

    public String getRegistryId() {
        return this.registryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceInstancesChangedListener)) {
            return false;
        }
        ServiceInstancesChangedListener that = (ServiceInstancesChangedListener)o;
        return Objects.equals(this.getServiceNames(), that.getServiceNames()) && Objects.equals(this.getRegistryId(), that.getRegistryId());
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.getServiceNames(), this.getRegistryId());
    }
}

