/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.metadata.event;

import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.metadata.collector.MetadataMetricsCollector;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.TypeWrapper;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataEvent
extends TimeCounterEvent {
    public MetadataEvent(ApplicationModel applicationModel, TypeWrapper typeWrapper) {
        super(applicationModel, typeWrapper);
        ScopeBeanFactory beanFactory = applicationModel.getBeanFactory();
        if (!beanFactory.isDestroyed()) {
            MetadataMetricsCollector collector = (MetadataMetricsCollector)((Object)beanFactory.getBean(MetadataMetricsCollector.class));
            super.setAvailable(collector != null && collector.isCollectEnabled());
        }
    }

    public static MetadataEvent toPushEvent(ApplicationModel applicationModel) {
        return new MetadataEvent(applicationModel, new TypeWrapper(MetricsLevel.APP, MetricsKey.METADATA_PUSH_METRIC_NUM, MetricsKey.METADATA_PUSH_METRIC_NUM_SUCCEED, MetricsKey.METADATA_PUSH_METRIC_NUM_FAILED));
    }

    public static MetadataEvent toSubscribeEvent(ApplicationModel applicationModel) {
        return new MetadataEvent(applicationModel, new TypeWrapper(MetricsLevel.APP, MetricsKey.METADATA_SUBSCRIBE_METRIC_NUM, MetricsKey.METADATA_SUBSCRIBE_METRIC_NUM_SUCCEED, MetricsKey.METADATA_SUBSCRIBE_METRIC_NUM_FAILED));
    }

    public static MetadataEvent toServiceSubscribeEvent(ApplicationModel applicationModel, String serviceKey) {
        MetadataEvent metadataEvent = new MetadataEvent(applicationModel, new TypeWrapper(MetricsLevel.APP, MetricsKey.STORE_PROVIDER_METADATA, MetricsKey.STORE_PROVIDER_METADATA_SUCCEED, MetricsKey.STORE_PROVIDER_METADATA_FAILED));
        metadataEvent.putAttachment("serviceKey", serviceKey);
        return metadataEvent;
    }
}

