/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.metrics.exception.MetricsException;
import org.apache.dubbo.metrics.model.MetricsKey;

public class MetricsSupport {
    private static final String version = Version.getVersion();
    private static final String commitId = Version.getLastCommitId();

    public static Map<String, String> applicationTags(String applicationName) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("ip", NetUtils.getLocalHost());
        tags.put("hostname", NetUtils.getLocalHostName());
        tags.put("application.name", applicationName);
        tags.put("application.version", version);
        tags.put(MetricsKey.METADATA_GIT_COMMITID_METRIC.getName(), commitId);
        return tags;
    }

    public static Map<String, String> serviceTags(String appAndServiceName) {
        String[] keys = appAndServiceName.split("_");
        if (keys.length != 2) {
            throw new MetricsException("Error service name: " + appAndServiceName);
        }
        Map<String, String> tags = MetricsSupport.applicationTags(keys[0]);
        tags.put("interface", keys[1]);
        return tags;
    }
}

