/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.Map;
import org.apache.dubbo.metrics.model.MetricsKey;
import org.apache.dubbo.metrics.model.MetricsSupport;

public class MetricsKeyWrapper {
    private final String type;
    private final MetricsKey metricsKey;
    private final boolean serviceLevel;

    public MetricsKeyWrapper(String type, MetricsKey metricsKey) {
        this(type, metricsKey, false);
    }

    public MetricsKeyWrapper(String type, MetricsKey metricsKey, boolean serviceLevel) {
        this.type = type;
        this.metricsKey = metricsKey;
        this.serviceLevel = serviceLevel;
    }

    public String getType() {
        return this.type;
    }

    public MetricsKey getMetricsKey() {
        return this.metricsKey;
    }

    public boolean isKey(MetricsKey metricsKey, String registryOpType) {
        return metricsKey == this.getMetricsKey() && registryOpType.equals(this.getType());
    }

    public boolean isServiceLevel() {
        return this.serviceLevel;
    }

    public String targetKey() {
        try {
            return String.format(this.metricsKey.getName(), this.type);
        }
        catch (Exception ignore) {
            return this.metricsKey.getName();
        }
    }

    public String targetDesc() {
        try {
            return String.format(this.metricsKey.getDescription(), this.type);
        }
        catch (Exception ignore) {
            return this.metricsKey.getDescription();
        }
    }

    public Map<String, String> tagName(String key) {
        return this.isServiceLevel() ? MetricsSupport.serviceTags(key) : MetricsSupport.applicationTags(key);
    }
}

