/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.metrics.model.Metric;
import org.apache.dubbo.metrics.model.MetricsKey;

public class ApplicationMetric
implements Metric {
    private final String applicationName;
    private static final String version = Version.getVersion();
    private static final String commitId = Version.getLastCommitId();

    public ApplicationMetric(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getData() {
        return version;
    }

    @Override
    public Map<String, String> getTags() {
        return ApplicationMetric.getTagsByName(this.getApplicationName());
    }

    public static Map<String, String> getTagsByName(String applicationName) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("ip", NetUtils.getLocalHost());
        tags.put("hostname", NetUtils.getLocalHostName());
        tags.put("application.name", applicationName);
        tags.put("application.version", version);
        tags.put(MetricsKey.METADATA_GIT_COMMITID_METRIC.getName(), commitId);
        return tags;
    }

    public static Map<String, String> getServiceTags(String appAndServiceName) {
        String[] keys = appAndServiceName.split("_");
        Map<String, String> tags = ApplicationMetric.getTagsByName(keys[0]);
        tags.put("interface", keys[1]);
        return tags;
    }
}

