/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.aggregate;

import com.tdunning.math.stats.TDigest;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.metrics.aggregate.Pane;
import org.apache.dubbo.metrics.aggregate.SlidingWindow;

public class TimeWindowQuantile {
    private final double compression;
    private final DigestSlidingWindow slidingWindow;

    public TimeWindowQuantile(double compression, int bucketNum, int timeWindowSeconds) {
        this.compression = compression;
        this.slidingWindow = new DigestSlidingWindow(compression, bucketNum, TimeUnit.SECONDS.toMillis(timeWindowSeconds));
    }

    public double quantile(double q) {
        TDigest mergeDigest = TDigest.createDigest((double)this.compression);
        List validWindows = this.slidingWindow.values();
        for (TDigest window : validWindows) {
            mergeDigest.add(window);
        }
        return mergeDigest.quantile(q);
    }

    public void add(double value) {
        ((TDigest)this.slidingWindow.currentPane().getValue()).add(value);
    }

    private static class DigestSlidingWindow
    extends SlidingWindow<TDigest> {
        private final double compression;

        public DigestSlidingWindow(double compression, int sampleCount, long intervalInMs) {
            super(sampleCount, intervalInMs);
            this.compression = compression;
        }

        @Override
        public TDigest newEmptyValue(long timeMillis) {
            return TDigest.createDigest((double)this.compression);
        }

        @Override
        protected Pane<TDigest> resetPaneTo(Pane<TDigest> pane, long startTime) {
            pane.setStartInMs(startTime);
            pane.setValue(TDigest.createDigest((double)this.compression));
            return pane;
        }
    }
}

