/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.bootstrap.builders.InternalServiceConfigBuilder;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.MetadataServiceV2;
import org.apache.dubbo.metadata.util.MetadataServiceVersionUtils;
import org.apache.dubbo.registry.client.metadata.MetadataServiceDelegation;
import org.apache.dubbo.registry.client.metadata.MetadataServiceDelegationV2;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigurableMetadataServiceExporter {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    @Deprecated
    private final MetadataServiceDelegation metadataService;
    private final MetadataServiceDelegationV2 metadataServiceV2;
    @Deprecated
    private volatile ServiceConfig<MetadataService> serviceConfig;
    private volatile ServiceConfig<MetadataServiceV2> serviceConfigV2;
    private final ApplicationModel applicationModel;
    private static final String INTERNAL_METADATA_REGISTRY_ID = "internal-metadata-registry";

    public ConfigurableMetadataServiceExporter(ApplicationModel applicationModel, MetadataServiceDelegation metadataService, MetadataServiceDelegationV2 metadataServiceV2) {
        this.applicationModel = applicationModel;
        this.metadataService = metadataService;
        this.metadataServiceV2 = metadataServiceV2;
    }

    public synchronized ConfigurableMetadataServiceExporter export() {
        if (this.serviceConfig == null || !this.isExported()) {
            if (MetadataServiceVersionUtils.needExportV1((ApplicationModel)this.applicationModel)) {
                this.exportV1();
            }
            if (MetadataServiceVersionUtils.needExportV2((ApplicationModel)this.applicationModel)) {
                this.exportV2();
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("5-26", "", "", "The MetadataService has been exported : " + this.serviceConfig.getExportedUrls());
        }
        return this;
    }

    private void exportV1() {
        ExecutorService internalServiceExecutor = ((FrameworkExecutorRepository)this.applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class)).getInternalServiceExecutor();
        this.serviceConfig = InternalServiceConfigBuilder.newBuilder(this.applicationModel).interfaceClass(MetadataService.class).protocol(this.getApplicationConfig().getMetadataServiceProtocol(), "metadata-service-protocol").port(this.getApplicationConfig().getMetadataServicePort(), "metadata-service-port").registryId(INTERNAL_METADATA_REGISTRY_ID).executor(internalServiceExecutor).ref((MetadataService)this.metadataService).version("1.0.0").build(configConsumer -> configConsumer.setMethods(this.generateMethodConfig()));
        this.serviceConfig.export();
        this.metadataService.setMetadataURL((URL)this.serviceConfig.getExportedUrls().get(0));
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The MetadataService exports urls : " + this.serviceConfig.getExportedUrls());
        }
    }

    private void exportV2() {
        ExecutorService internalServiceExecutor = ((FrameworkExecutorRepository)this.applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class)).getInternalServiceExecutor();
        this.serviceConfigV2 = InternalServiceConfigBuilder.newBuilder(this.applicationModel).interfaceClass(MetadataServiceV2.class).protocol("tri", "metadata-service-protocol").port(this.getApplicationConfig().getMetadataServicePort(), "metadata-service-port").registryId(INTERNAL_METADATA_REGISTRY_ID).executor(internalServiceExecutor).ref((MetadataServiceV2)this.metadataServiceV2).version("2.0.0").build();
        this.serviceConfigV2.export();
        this.metadataServiceV2.setMetadataUrl((URL)this.serviceConfigV2.getExportedUrls().get(0));
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The MetadataServiceV2 exports urls : " + this.serviceConfigV2.getExportedUrls());
        }
    }

    public ConfigurableMetadataServiceExporter unexport() {
        if (this.isExported()) {
            this.serviceConfig.unexport();
            this.serviceConfigV2.unexport();
            this.metadataService.setMetadataURL(null);
        }
        return this;
    }

    private boolean v1Exported() {
        return this.serviceConfig != null && this.serviceConfig.isExported() && !this.serviceConfig.isUnexported();
    }

    private boolean v2Exported() {
        return this.serviceConfigV2 != null && this.serviceConfigV2.isExported() && !this.serviceConfigV2.isUnexported();
    }

    public boolean isExported() {
        return this.v1Exported() || this.v2Exported();
    }

    private ApplicationConfig getApplicationConfig() {
        return (ApplicationConfig)this.applicationModel.getApplicationConfigManager().getApplication().get();
    }

    private List<MethodConfig> generateMethodConfig() {
        MethodConfig methodConfig = new MethodConfig();
        methodConfig.setName("getAndListenInstanceMetadata");
        ArgumentConfig argumentConfig = new ArgumentConfig();
        argumentConfig.setIndex(Integer.valueOf(1));
        argumentConfig.setCallback(Boolean.valueOf(true));
        methodConfig.setArguments(Collections.singletonList(argumentConfig));
        return Collections.singletonList(methodConfig);
    }
}

