/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.deploy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.config.ReferenceCache;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.config.configcenter.DynamicConfigurationFactory;
import org.apache.dubbo.common.config.configcenter.wrapper.CompositeDynamicConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.deploy.AbstractDeployer;
import org.apache.dubbo.common.deploy.ApplicationDeployListener;
import org.apache.dubbo.common.deploy.ApplicationDeployer;
import org.apache.dubbo.common.deploy.DeployListener;
import org.apache.dubbo.common.deploy.DeployState;
import org.apache.dubbo.common.deploy.ModuleDeployer;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.DubboShutdownHook;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.utils.CompositeReferenceCache;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.metadata.report.MetadataReportFactory;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.support.RegistryManager;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class DefaultApplicationDeployer
extends AbstractDeployer<ApplicationModel>
implements ApplicationDeployer {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DefaultApplicationDeployer.class);
    private final ApplicationModel applicationModel;
    private final ConfigManager configManager;
    private final Environment environment;
    private final ReferenceCache referenceCache;
    private final FrameworkExecutorRepository frameworkExecutorRepository;
    private final ExecutorRepository executorRepository;
    private final AtomicBoolean hasPreparedApplicationInstance = new AtomicBoolean(false);
    private volatile boolean hasPreparedInternalModule = false;
    private ScheduledFuture<?> asyncMetadataFuture;
    private volatile CompletableFuture<Boolean> startFuture;
    private final DubboShutdownHook dubboShutdownHook;
    private final Object stateLock = new Object();
    private final Object startLock = new Object();
    private final Object destroyLock = new Object();
    private final Object internalModuleLock = new Object();
    private volatile boolean registered;

    public DefaultApplicationDeployer(ApplicationModel applicationModel) {
        super((ScopeModel)applicationModel);
        this.applicationModel = applicationModel;
        this.configManager = applicationModel.getApplicationConfigManager();
        this.environment = applicationModel.getModelEnvironment();
        this.referenceCache = new CompositeReferenceCache(applicationModel);
        this.frameworkExecutorRepository = (FrameworkExecutorRepository)applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class);
        this.executorRepository = (ExecutorRepository)this.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
        this.dubboShutdownHook = new DubboShutdownHook(applicationModel);
        Set deployListeners = applicationModel.getExtensionLoader(ApplicationDeployListener.class).getSupportedExtensionInstances();
        for (ApplicationDeployListener listener : deployListeners) {
            this.addDeployListener((DeployListener)listener);
        }
    }

    public static ApplicationDeployer get(ScopeModel moduleOrApplicationModel) {
        ApplicationModel applicationModel = ScopeModelUtil.getApplicationModel((ScopeModel)moduleOrApplicationModel);
        ApplicationDeployer applicationDeployer = applicationModel.getDeployer();
        if (applicationDeployer == null) {
            applicationDeployer = (ApplicationDeployer)applicationModel.getBeanFactory().getOrRegisterBean(DefaultApplicationDeployer.class);
        }
        return applicationDeployer;
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    private <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        return this.applicationModel.getExtensionLoader(type);
    }

    private void unRegisterShutdownHook() {
        this.dubboShutdownHook.unregister();
    }

    private boolean isRegisterConsumerInstance() {
        Boolean registerConsumer = this.getApplication().getRegisterConsumer();
        if (registerConsumer == null) {
            return true;
        }
        return Boolean.TRUE.equals(registerConsumer);
    }

    public ReferenceCache getReferenceCache() {
        return this.referenceCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (this.initialized) {
            return;
        }
        Object object = this.startLock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            this.registerShutdownHook();
            this.startConfigCenter();
            this.loadApplicationConfigs();
            this.initModuleDeployers();
            this.startMetadataCenter();
            this.initialized = true;
            if (logger.isInfoEnabled()) {
                logger.info(this.getIdentifier() + " has been initialized!");
            }
        }
    }

    private void registerShutdownHook() {
        this.dubboShutdownHook.register();
    }

    private void initModuleDeployers() {
        this.applicationModel.getDefaultModule();
        ArrayList moduleModels = new ArrayList(this.applicationModel.getModuleModels());
        for (ModuleModel moduleModel : moduleModels) {
            moduleModel.getDeployer().initialize();
        }
    }

    private void loadApplicationConfigs() {
        this.configManager.loadConfigs();
    }

    private void startConfigCenter() {
        this.configManager.loadConfigsOfTypeFromProps(ApplicationConfig.class);
        if (StringUtils.isBlank((CharSequence)this.applicationModel.getModelName())) {
            this.applicationModel.setModelName(this.applicationModel.tryGetApplicationName());
        }
        this.configManager.loadConfigsOfTypeFromProps(ConfigCenterConfig.class);
        this.useRegistryAsConfigCenterIfNecessary();
        Collection configCenters = this.configManager.getConfigCenters();
        if (CollectionUtils.isEmpty((Collection)configCenters)) {
            ConfigCenterConfig configCenterConfig = new ConfigCenterConfig();
            configCenterConfig.setScopeModel((ScopeModel)this.applicationModel);
            configCenterConfig.refresh();
            ConfigValidationUtils.validateConfigCenterConfig(configCenterConfig);
            if (configCenterConfig.isValid()) {
                this.configManager.addConfigCenter(configCenterConfig);
                configCenters = this.configManager.getConfigCenters();
            }
        } else {
            for (ConfigCenterConfig configCenterConfig : configCenters) {
                configCenterConfig.refresh();
                ConfigValidationUtils.validateConfigCenterConfig(configCenterConfig);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)configCenters)) {
            CompositeDynamicConfiguration compositeDynamicConfiguration = new CompositeDynamicConfiguration();
            for (ConfigCenterConfig configCenter : configCenters) {
                this.environment.updateExternalConfigMap(configCenter.getExternalConfiguration());
                this.environment.updateAppExternalConfigMap(configCenter.getAppExternalConfiguration());
                compositeDynamicConfiguration.addConfiguration(this.prepareEnvironment(configCenter));
            }
            this.environment.setDynamicConfiguration((DynamicConfiguration)compositeDynamicConfiguration);
        }
    }

    private void startMetadataCenter() {
        this.useRegistryAsMetadataCenterIfNecessary();
        ApplicationConfig applicationConfig = this.getApplication();
        String metadataType = applicationConfig.getMetadataType();
        Collection metadataReportConfigs = this.configManager.getMetadataConfigs();
        if (CollectionUtils.isEmpty((Collection)metadataReportConfigs)) {
            if ("remote".equals(metadataType)) {
                throw new IllegalStateException("No MetadataConfig found, Metadata Center address is required when 'metadata=remote' is enabled.");
            }
            return;
        }
        MetadataReportInstance metadataReportInstance = (MetadataReportInstance)this.applicationModel.getBeanFactory().getBean(MetadataReportInstance.class);
        ArrayList<MetadataReportConfig> validMetadataReportConfigs = new ArrayList<MetadataReportConfig>(metadataReportConfigs.size());
        for (MetadataReportConfig metadataReportConfig : metadataReportConfigs) {
            if (!ConfigValidationUtils.isValidMetadataConfig(metadataReportConfig)) continue;
            ConfigValidationUtils.validateMetadataConfig(metadataReportConfig);
            validMetadataReportConfigs.add(metadataReportConfig);
        }
        metadataReportInstance.init(validMetadataReportConfigs);
        if (!metadataReportInstance.inited()) {
            throw new IllegalStateException(String.format("%s MetadataConfigs found, but none of them is valid.", metadataReportConfigs.size()));
        }
    }

    private void useRegistryAsConfigCenterIfNecessary() {
        if (this.environment.getDynamicConfiguration().isPresent()) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)this.configManager.getConfigCenters())) {
            return;
        }
        this.configManager.loadConfigsOfTypeFromProps(RegistryConfig.class);
        List defaultRegistries = this.configManager.getDefaultRegistries();
        if (defaultRegistries.size() > 0) {
            defaultRegistries.stream().filter(this::isUsedRegistryAsConfigCenter).map(this::registryAsConfigCenter).forEach(configCenter -> {
                if (this.configManager.getConfigCenter(configCenter.getId()).isPresent()) {
                    return;
                }
                this.configManager.addConfigCenter(configCenter);
                logger.info("use registry as config-center: " + configCenter);
            });
        }
    }

    private boolean isUsedRegistryAsConfigCenter(RegistryConfig registryConfig) {
        return this.isUsedRegistryAsCenter(registryConfig, () -> ((RegistryConfig)registryConfig).getUseAsConfigCenter(), "config", DynamicConfigurationFactory.class);
    }

    private ConfigCenterConfig registryAsConfigCenter(RegistryConfig registryConfig) {
        String protocol = registryConfig.getProtocol();
        Integer port = registryConfig.getPort();
        URL url = URL.valueOf((String)registryConfig.getAddress(), (ScopeModel)registryConfig.getScopeModel());
        String id = "config-center-" + protocol + "-" + url.getHost() + "-" + port;
        ConfigCenterConfig cc = new ConfigCenterConfig();
        cc.setId(id);
        cc.setScopeModel((ScopeModel)this.applicationModel);
        if (cc.getParameters() == null) {
            cc.setParameters(new HashMap());
        }
        if (CollectionUtils.isNotEmptyMap((Map)registryConfig.getParameters())) {
            cc.getParameters().putAll(registryConfig.getParameters());
        }
        cc.getParameters().put("client", registryConfig.getClient());
        cc.setProtocol(protocol);
        cc.setPort(port);
        if (StringUtils.isNotEmpty((String)registryConfig.getGroup())) {
            cc.setGroup(registryConfig.getGroup());
        }
        cc.setAddress(this.getRegistryCompatibleAddress(registryConfig));
        cc.setNamespace(registryConfig.getGroup());
        cc.setUsername(registryConfig.getUsername());
        cc.setPassword(registryConfig.getPassword());
        if (registryConfig.getTimeout() != null) {
            cc.setTimeout(Long.valueOf(registryConfig.getTimeout().longValue()));
        }
        cc.setHighestPriority(Boolean.valueOf(false));
        return cc;
    }

    private void useRegistryAsMetadataCenterIfNecessary() {
        Collection originMetadataConfigs = this.configManager.getMetadataConfigs();
        if (originMetadataConfigs.stream().anyMatch(m -> Objects.nonNull(m.getAddress()))) {
            return;
        }
        Collection metadataConfigsToOverride = originMetadataConfigs.stream().filter(m -> Objects.isNull(m.getAddress())).collect(Collectors.toList());
        if (metadataConfigsToOverride.size() > 1) {
            return;
        }
        MetadataReportConfig metadataConfigToOverride = metadataConfigsToOverride.stream().findFirst().orElse(null);
        List defaultRegistries = this.configManager.getDefaultRegistries();
        if (!defaultRegistries.isEmpty()) {
            defaultRegistries.stream().filter(this::isUsedRegistryAsMetadataCenter).map(registryConfig -> this.registryAsMetadataCenter((RegistryConfig)registryConfig, metadataConfigToOverride)).forEach(metadataReportConfig -> this.overrideMetadataReportConfig(metadataConfigToOverride, (MetadataReportConfig)metadataReportConfig));
        }
    }

    private void overrideMetadataReportConfig(MetadataReportConfig metadataConfigToOverride, MetadataReportConfig metadataReportConfig) {
        if (metadataReportConfig.getId() == null) {
            Collection metadataReportConfigs = this.configManager.getMetadataConfigs();
            if (CollectionUtils.isNotEmpty((Collection)metadataReportConfigs)) {
                for (MetadataReportConfig existedConfig : metadataReportConfigs) {
                    if (existedConfig.getId() != null || !existedConfig.getAddress().equals(metadataReportConfig.getAddress())) continue;
                    return;
                }
            }
            this.configManager.removeConfig((AbstractConfig)metadataConfigToOverride);
            this.configManager.addMetadataReport(metadataReportConfig);
        } else {
            Optional configOptional = this.configManager.getConfig(MetadataReportConfig.class, metadataReportConfig.getId());
            if (configOptional.isPresent()) {
                return;
            }
            this.configManager.removeConfig((AbstractConfig)metadataConfigToOverride);
            this.configManager.addMetadataReport(metadataReportConfig);
        }
        logger.info("use registry as metadata-center: " + metadataReportConfig);
    }

    private boolean isUsedRegistryAsMetadataCenter(RegistryConfig registryConfig) {
        return this.isUsedRegistryAsCenter(registryConfig, () -> ((RegistryConfig)registryConfig).getUseAsMetadataCenter(), "metadata", MetadataReportFactory.class);
    }

    private boolean isUsedRegistryAsCenter(RegistryConfig registryConfig, Supplier<Boolean> usedRegistryAsCenter, String centerType, Class<?> extensionClass) {
        boolean supported;
        Boolean configuredValue = usedRegistryAsCenter.get();
        if (configuredValue != null) {
            supported = configuredValue;
        } else {
            String protocol = registryConfig.getProtocol();
            supported = this.supportsExtension(extensionClass, protocol);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("No value is configured in the registry, the %s extension[name : %s] %s as the %s center", extensionClass.getSimpleName(), protocol, supported ? "supports" : "does not support", centerType));
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("The registry[%s] will be %s as the %s center", registryConfig, supported ? "used" : "not used", centerType));
        }
        return supported;
    }

    private boolean supportsExtension(Class<?> extensionClass, String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            ExtensionLoader<?> extensionLoader = this.getExtensionLoader(extensionClass);
            return extensionLoader.hasExtension(name);
        }
        return false;
    }

    private MetadataReportConfig registryAsMetadataCenter(RegistryConfig registryConfig, MetadataReportConfig originMetadataReportConfig) {
        MetadataReportConfig metadataReportConfig;
        MetadataReportConfig metadataReportConfig2 = metadataReportConfig = originMetadataReportConfig == null ? new MetadataReportConfig(registryConfig.getApplicationModel()) : originMetadataReportConfig;
        if (metadataReportConfig.getId() == null) {
            metadataReportConfig.setId(registryConfig.getId());
        }
        metadataReportConfig.setScopeModel((ScopeModel)this.applicationModel);
        if (metadataReportConfig.getParameters() == null) {
            metadataReportConfig.setParameters(new HashMap());
        }
        if (CollectionUtils.isNotEmptyMap((Map)registryConfig.getParameters())) {
            for (Map.Entry entry : registryConfig.getParameters().entrySet()) {
                metadataReportConfig.getParameters().putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        metadataReportConfig.getParameters().put("client", registryConfig.getClient());
        if (metadataReportConfig.getGroup() == null) {
            metadataReportConfig.setGroup(registryConfig.getGroup());
        }
        if (metadataReportConfig.getAddress() == null) {
            metadataReportConfig.setAddress(this.getRegistryCompatibleAddress(registryConfig));
        }
        if (metadataReportConfig.getUsername() == null) {
            metadataReportConfig.setUsername(registryConfig.getUsername());
        }
        if (metadataReportConfig.getPassword() == null) {
            metadataReportConfig.setPassword(registryConfig.getPassword());
        }
        if (metadataReportConfig.getTimeout() == null) {
            metadataReportConfig.setTimeout(registryConfig.getTimeout());
        }
        return metadataReportConfig;
    }

    private String getRegistryCompatibleAddress(RegistryConfig registryConfig) {
        String registryAddress = registryConfig.getAddress();
        Object[] addresses = CommonConstants.REGISTRY_SPLIT_PATTERN.split(registryAddress);
        if (ArrayUtils.isEmpty((Object[])addresses)) {
            throw new IllegalStateException("Invalid registry address found.");
        }
        Object address = addresses[0];
        StringBuilder metadataAddressBuilder = new StringBuilder();
        URL url = URL.valueOf((String)address, (ScopeModel)registryConfig.getScopeModel());
        String protocolFromAddress = url.getProtocol();
        if (StringUtils.isEmpty((String)protocolFromAddress)) {
            String protocolFromConfig = registryConfig.getProtocol();
            metadataAddressBuilder.append(protocolFromConfig).append("://");
        }
        metadataAddressBuilder.append((String)address);
        return metadataAddressBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future start() {
        Object object = this.startLock;
        synchronized (object) {
            if (this.isStopping() || this.isStopped() || this.isFailed()) {
                throw new IllegalStateException(this.getIdentifier() + " is stopping or stopped, can not start again");
            }
            try {
                boolean hasPendingModule = this.hasPendingModule();
                if (this.isStarting()) {
                    if (hasPendingModule) {
                        this.startModules();
                    }
                    return this.startFuture;
                }
                if (this.isStarted() && !hasPendingModule) {
                    return CompletableFuture.completedFuture(false);
                }
                this.onStarting();
                this.initialize();
                this.doStart();
            }
            catch (Throwable e) {
                this.onFailed(this.getIdentifier() + " start failure", e);
                throw e;
            }
            return this.startFuture;
        }
    }

    private boolean hasPendingModule() {
        boolean found = false;
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            if (!moduleModel.getDeployer().isPending()) continue;
            found = true;
            break;
        }
        return found;
    }

    public Future getStartFuture() {
        return this.startFuture;
    }

    private void doStart() {
        this.startModules();
    }

    private void startModules() {
        this.prepareInternalModule();
        for (ModuleModel moduleModel : new ArrayList(this.applicationModel.getModuleModels())) {
            if (!moduleModel.getDeployer().isPending()) continue;
            moduleModel.getDeployer().start();
        }
    }

    public void prepareApplicationInstance() {
        if (this.hasPreparedApplicationInstance.get()) {
            return;
        }
        if (this.isRegisterConsumerInstance()) {
            this.exportMetadataService();
            if (this.hasPreparedApplicationInstance.compareAndSet(false, true)) {
                this.registerServiceInstance();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareInternalModule() {
        if (this.hasPreparedInternalModule) {
            return;
        }
        Object object = this.internalModuleLock;
        synchronized (object) {
            if (this.hasPreparedInternalModule) {
                return;
            }
            ModuleDeployer internalModuleDeployer = this.applicationModel.getInternalModule().getDeployer();
            if (!internalModuleDeployer.isStarted()) {
                Future future = internalModuleDeployer.start();
                try {
                    future.get(5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    logger.warn("5-14", "", "", "wait for internal module startup failed: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private boolean hasExportedServices() {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            if (!CollectionUtils.isNotEmpty((Collection)moduleModel.getConfigManager().getServices())) continue;
            return true;
        }
        return false;
    }

    public boolean isBackground() {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            if (!moduleModel.getDeployer().isBackground()) continue;
            return true;
        }
        return false;
    }

    private DynamicConfiguration prepareEnvironment(ConfigCenterConfig configCenter) {
        if (configCenter.isValid()) {
            DynamicConfiguration dynamicConfiguration;
            if (!configCenter.checkOrUpdateInitialized(true)) {
                return null;
            }
            try {
                dynamicConfiguration = this.getDynamicConfiguration(configCenter.toUrl());
            }
            catch (Exception e) {
                if (!configCenter.isCheck().booleanValue()) {
                    logger.warn("5-22", "", "", "The configuration center failed to initialize", (Throwable)e);
                    configCenter.setInitialized(false);
                    return null;
                }
                throw new IllegalStateException(e);
            }
            if (StringUtils.isNotEmpty((String)configCenter.getConfigFile())) {
                String configContent = dynamicConfiguration.getProperties(configCenter.getConfigFile(), configCenter.getGroup());
                String appGroup = this.getApplication().getName();
                String appConfigContent = null;
                if (StringUtils.isNotEmpty((String)appGroup)) {
                    appConfigContent = dynamicConfiguration.getProperties(StringUtils.isNotEmpty((String)configCenter.getAppConfigFile()) ? configCenter.getAppConfigFile() : configCenter.getConfigFile(), appGroup);
                }
                try {
                    this.environment.updateExternalConfigMap(ConfigurationUtils.parseProperties((String)configContent));
                    this.environment.updateAppExternalConfigMap(ConfigurationUtils.parseProperties((String)appConfigContent));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to parse configurations from Config Center.", e);
                }
            }
            return dynamicConfiguration;
        }
        return null;
    }

    private DynamicConfiguration getDynamicConfiguration(URL connectionURL) {
        String protocol = connectionURL.getProtocol();
        DynamicConfigurationFactory factory = ConfigurationUtils.getDynamicConfigurationFactory((ExtensionAccessor)this.applicationModel, (String)protocol);
        return factory.getDynamicConfiguration(connectionURL);
    }

    private void registerServiceInstance() {
        try {
            this.registered = true;
            ServiceInstanceMetadataUtils.registerMetadataAndInstance((ApplicationModel)this.applicationModel);
        }
        catch (Exception e) {
            logger.error("5-11", "configuration server disconnected", "", "Register instance error.", (Throwable)e);
        }
        if (this.registered) {
            this.asyncMetadataFuture = this.frameworkExecutorRepository.getSharedScheduledExecutor().scheduleWithFixedDelay(() -> {
                block4: {
                    if (this.applicationModel.isDestroyed()) {
                        return;
                    }
                    try {
                        if (!this.applicationModel.isDestroyed() && this.registered) {
                            ServiceInstanceMetadataUtils.refreshMetadataAndInstance((ApplicationModel)this.applicationModel);
                        }
                    }
                    catch (Exception e) {
                        if (this.applicationModel.isDestroyed()) break block4;
                        logger.error("5-12", "", "", "Refresh instance and metadata error.", (Throwable)e);
                    }
                }
            }, 0L, ConfigurationUtils.get((ScopeModel)this.applicationModel, (String)"dubbo.application.metadata.publish.delay", (int)30000), TimeUnit.MILLISECONDS);
        }
    }

    private void unregisterServiceInstance() {
        if (this.registered) {
            ServiceInstanceMetadataUtils.unregisterMetadataAndInstance((ApplicationModel)this.applicationModel);
        }
    }

    public void stop() {
        this.applicationModel.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDestroy() {
        Object object = this.destroyLock;
        synchronized (object) {
            if (this.isStopping() || this.isStopped()) {
                return;
            }
            this.onStopping();
            this.unregisterServiceInstance();
            this.unRegisterShutdownHook();
            if (this.asyncMetadataFuture != null) {
                this.asyncMetadataFuture.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDestroy() {
        Object object = this.destroyLock;
        synchronized (object) {
            if (this.isStopped()) {
                return;
            }
            try {
                this.destroyRegistries();
                this.destroyMetadataReports();
                this.executeShutdownCallbacks();
                this.destroyExecutorRepository();
                this.onStopped();
            }
            catch (Throwable ex) {
                String msg = this.getIdentifier() + " an error occurred while stopping application: " + ex.getMessage();
                this.onFailed(msg, ex);
            }
        }
    }

    private void executeShutdownCallbacks() {
        ShutdownHookCallbacks shutdownHookCallbacks = (ShutdownHookCallbacks)this.applicationModel.getBeanFactory().getBean(ShutdownHookCallbacks.class);
        shutdownHookCallbacks.callback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyModuleChanged(ModuleModel moduleModel, DeployState state) {
        this.checkState(moduleModel, state);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkState(ModuleModel moduleModel, DeployState moduleState) {
        Object object = this.stateLock;
        synchronized (object) {
            if (!moduleModel.isInternal() && moduleState == DeployState.STARTED) {
                this.prepareApplicationInstance();
            }
            DeployState newState = this.calculateState();
            switch (newState) {
                case STARTED: {
                    this.onStarted();
                    break;
                }
                case STARTING: {
                    this.onStarting();
                    break;
                }
                case STOPPING: {
                    this.onStopping();
                    break;
                }
                case STOPPED: {
                    this.onStopped();
                    break;
                }
                case FAILED: {
                    Throwable error = null;
                    ModuleModel errorModule = null;
                    for (ModuleModel module : this.applicationModel.getModuleModels()) {
                        ModuleDeployer deployer = module.getDeployer();
                        if (!deployer.isFailed() || deployer.getError() == null) continue;
                        error = deployer.getError();
                        errorModule = module;
                        break;
                    }
                    this.onFailed(this.getIdentifier() + " found failed module: " + errorModule.getDesc(), error);
                    break;
                }
            }
        }
    }

    private DeployState calculateState() {
        DeployState newState = DeployState.UNKNOWN;
        int pending = 0;
        int starting = 0;
        int started = 0;
        int stopping = 0;
        int stopped = 0;
        int failed = 0;
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            ModuleDeployer deployer = moduleModel.getDeployer();
            if (deployer == null) {
                ++pending;
                continue;
            }
            if (deployer.isPending()) {
                ++pending;
                continue;
            }
            if (deployer.isStarting()) {
                ++starting;
                continue;
            }
            if (deployer.isStarted()) {
                ++started;
                continue;
            }
            if (deployer.isStopping()) {
                ++stopping;
                continue;
            }
            if (deployer.isStopped()) {
                ++stopped;
                continue;
            }
            if (!deployer.isFailed()) continue;
            ++failed;
        }
        if (failed > 0) {
            newState = DeployState.FAILED;
        } else if (started > 0) {
            if (pending + starting + stopping + stopped == 0) {
                newState = DeployState.STARTED;
            } else if (pending + starting > 0) {
                newState = DeployState.STARTING;
            } else if (stopping + stopped > 0) {
                newState = DeployState.STOPPING;
            }
        } else if (starting > 0) {
            newState = DeployState.STARTING;
        } else if (pending > 0) {
            if (starting + starting + stopping + stopped == 0) {
                newState = DeployState.PENDING;
            } else if (stopping + stopped > 0) {
                newState = DeployState.STOPPING;
            }
        } else if (stopping > 0) {
            newState = DeployState.STOPPING;
        } else if (stopped > 0) {
            newState = DeployState.STOPPED;
        }
        return newState;
    }

    private void exportMetadataService() {
        if (!this.isStarting()) {
            return;
        }
        for (DeployListener listener : this.listeners) {
            try {
                if (!(listener instanceof ApplicationDeployListener)) continue;
                ((ApplicationDeployListener)listener).onModuleStarted(this.applicationModel);
            }
            catch (Throwable e) {
                logger.error("5-14", "", "", this.getIdentifier() + " an exception occurred when handle starting event", e);
            }
        }
    }

    private void onStarting() {
        if (!this.isPending() && !this.isStarted()) {
            return;
        }
        this.setStarting();
        this.startFuture = new CompletableFuture();
        if (logger.isInfoEnabled()) {
            logger.info(this.getIdentifier() + " is starting.");
        }
    }

    private void onStarted() {
        try {
            if (!this.isStarting()) {
                return;
            }
            this.setStarted();
            if (logger.isInfoEnabled()) {
                logger.info(this.getIdentifier() + " is ready.");
            }
            try {
                if (this.registered) {
                    ServiceInstanceMetadataUtils.refreshMetadataAndInstance((ApplicationModel)this.applicationModel);
                }
            }
            catch (Exception e) {
                logger.error("5-12", "", "", "Refresh instance and metadata error.", (Throwable)e);
            }
        }
        finally {
            this.completeStartFuture(true);
        }
    }

    private void completeStartFuture(boolean success) {
        if (this.startFuture != null) {
            this.startFuture.complete(success);
        }
    }

    private void onStopping() {
        try {
            if (this.isStopping() || this.isStopped()) {
                return;
            }
            this.setStopping();
            if (logger.isInfoEnabled()) {
                logger.info(this.getIdentifier() + " is stopping.");
            }
        }
        finally {
            this.completeStartFuture(false);
        }
    }

    private void onStopped() {
        try {
            if (this.isStopped()) {
                return;
            }
            this.setStopped();
            if (logger.isInfoEnabled()) {
                logger.info(this.getIdentifier() + " has stopped.");
            }
        }
        finally {
            this.completeStartFuture(false);
        }
    }

    private void onFailed(String msg, Throwable ex) {
        try {
            this.setFailed(ex);
            logger.error("5-14", "", "", msg, ex);
        }
        finally {
            this.completeStartFuture(false);
        }
    }

    private void destroyExecutorRepository() {
        this.executorRepository.shutdownServiceExportExecutor();
        this.executorRepository.shutdownServiceReferExecutor();
        ((ExecutorRepository)this.getExtensionLoader(ExecutorRepository.class).getDefaultExtension()).destroyAll();
    }

    private void destroyRegistries() {
        RegistryManager.getInstance((ApplicationModel)this.applicationModel).destroyAll();
    }

    private void destroyServiceDiscoveries() {
        RegistryManager.getInstance((ApplicationModel)this.applicationModel).getServiceDiscoveries().forEach(serviceDiscovery -> {
            try {
                serviceDiscovery.destroy();
            }
            catch (Throwable ignored) {
                logger.warn("5-21", "", "", ignored.getMessage(), ignored);
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug(this.getIdentifier() + "'s all ServiceDiscoveries have been destroyed.");
        }
    }

    private void destroyMetadataReports() {
        List metadataReportFactories = this.getExtensionLoader(MetadataReportFactory.class).getLoadedExtensionInstances();
        for (MetadataReportFactory metadataReportFactory : metadataReportFactories) {
            metadataReportFactory.destroy();
        }
    }

    private ApplicationConfig getApplication() {
        return this.configManager.getApplicationOrElseThrow();
    }
}

