/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.executor;

import java.util.List;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.rpc.executor.ExecutorSupport;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;

public abstract class AbstractIsolationExecutorSupport
implements ExecutorSupport {
    private final URL url;
    private final ExecutorRepository executorRepository;
    private final FrameworkServiceRepository frameworkServiceRepository;

    public AbstractIsolationExecutorSupport(URL url) {
        this.url = url;
        this.executorRepository = ExecutorRepository.getInstance(url.getOrDefaultApplicationModel());
        this.frameworkServiceRepository = url.getOrDefaultFrameworkModel().getServiceRepository();
    }

    @Override
    public Executor getExecutor(Object data) {
        ProviderModel providerModel = this.getProviderModel(data);
        if (providerModel == null) {
            return this.executorRepository.getExecutor(this.url);
        }
        List<URL> serviceUrls = providerModel.getServiceUrls();
        if (serviceUrls == null || serviceUrls.isEmpty()) {
            return this.executorRepository.getExecutor(this.url);
        }
        for (URL serviceUrl : serviceUrls) {
            if (!serviceUrl.getProtocol().equals(this.url.getProtocol()) || serviceUrl.getPort() != this.url.getPort()) continue;
            return this.executorRepository.getExecutor(providerModel, serviceUrl);
        }
        return this.executorRepository.getExecutor(providerModel, serviceUrls.get(0));
    }

    protected String getServiceKey(Object data) {
        return null;
    }

    protected ProviderModel getProviderModel(Object data) {
        String serviceKey = this.getServiceKey(data);
        return serviceKey == null ? null : this.frameworkServiceRepository.lookupExportedService(serviceKey);
    }
}

