/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.Node;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.router.state.BitList;

public class RouterSnapshotNode<T> {
    private final String name;
    private final int beforeSize;
    private int nodeOutputSize;
    private int chainOutputSize;
    private String routerMessage;
    private final List<Invoker<T>> inputInvokers;
    private List<Invoker<T>> nodeOutputInvokers;
    private List<Invoker<T>> chainOutputInvokers;
    private final List<RouterSnapshotNode<T>> nextNode = new LinkedList<RouterSnapshotNode<T>>();
    private RouterSnapshotNode<T> parentNode;

    public RouterSnapshotNode(String name, List<Invoker<T>> inputInvokers) {
        this.name = name;
        this.beforeSize = inputInvokers.size();
        if (inputInvokers instanceof BitList) {
            this.inputInvokers = inputInvokers;
        } else {
            this.inputInvokers = new ArrayList<Invoker<T>>(5);
            for (int i = 0; i < Math.min(5, this.beforeSize); ++i) {
                this.inputInvokers.add(inputInvokers.get(i));
            }
        }
        this.nodeOutputSize = 0;
    }

    public String getName() {
        return this.name;
    }

    public int getBeforeSize() {
        return this.beforeSize;
    }

    public int getNodeOutputSize() {
        return this.nodeOutputSize;
    }

    public String getRouterMessage() {
        return this.routerMessage;
    }

    public void setRouterMessage(String routerMessage) {
        this.routerMessage = routerMessage;
    }

    public List<Invoker<T>> getNodeOutputInvokers() {
        return this.nodeOutputInvokers;
    }

    public void setNodeOutputInvokers(List<Invoker<T>> outputInvokers) {
        this.nodeOutputInvokers = outputInvokers;
        this.nodeOutputSize = outputInvokers == null ? 0 : outputInvokers.size();
    }

    public void setChainOutputInvokers(List<Invoker<T>> outputInvokers) {
        this.chainOutputInvokers = outputInvokers;
        this.chainOutputSize = outputInvokers == null ? 0 : outputInvokers.size();
    }

    public int getChainOutputSize() {
        return this.chainOutputSize;
    }

    public List<Invoker<T>> getChainOutputInvokers() {
        return this.chainOutputInvokers;
    }

    public List<RouterSnapshotNode<T>> getNextNode() {
        return this.nextNode;
    }

    public RouterSnapshotNode<T> getParentNode() {
        return this.parentNode;
    }

    public void appendNode(RouterSnapshotNode<T> nextNode) {
        this.nextNode.add(nextNode);
        nextNode.parentNode = this;
    }

    public String toString() {
        return this.toString(1);
    }

    public String toString(int level) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ").append(this.name).append(" ").append("(Input: ").append(this.beforeSize).append(") ").append("(Current Node Output: ").append(this.nodeOutputSize).append(") ").append("(Chain Node Output: ").append(this.chainOutputSize).append(")").append(this.routerMessage == null ? "" : " Router message: ").append(this.routerMessage == null ? "" : this.routerMessage).append(" ] ");
        if (level == 1) {
            stringBuilder.append("Input: ").append(CollectionUtils.isEmpty(this.inputInvokers) ? "Empty" : this.inputInvokers.subList(0, Math.min(5, this.inputInvokers.size())).stream().map(Node::getUrl).map(URL::getAddress).collect(Collectors.joining(","))).append(" -> ");
            stringBuilder.append("Chain Node Output: ").append(CollectionUtils.isEmpty(this.chainOutputInvokers) ? "Empty" : this.chainOutputInvokers.subList(0, Math.min(5, this.chainOutputInvokers.size())).stream().map(Node::getUrl).map(URL::getAddress).collect(Collectors.joining(",")));
        } else {
            stringBuilder.append("Current Node Output: ").append(CollectionUtils.isEmpty(this.nodeOutputInvokers) ? "Empty" : this.nodeOutputInvokers.subList(0, Math.min(5, this.nodeOutputInvokers.size())).stream().map(Node::getUrl).map(URL::getAddress).collect(Collectors.joining(",")));
        }
        if (this.nodeOutputInvokers != null && this.nodeOutputInvokers.size() > 5) {
            stringBuilder.append("...");
        }
        for (RouterSnapshotNode<T> node : this.nextNode) {
            stringBuilder.append("\n");
            for (int i = 0; i < level; ++i) {
                stringBuilder.append("  ");
            }
            stringBuilder.append(node.toString(level + 1));
        }
        return stringBuilder.toString();
    }
}

