/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.directory;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.directory.AbstractDirectory;
import org.apache.dubbo.rpc.cluster.router.state.BitList;

public class StaticDirectory<T>
extends AbstractDirectory<T> {
    private static final Logger logger = LoggerFactory.getLogger(StaticDirectory.class);

    public StaticDirectory(List<Invoker<T>> invokers) {
        this(null, invokers, null);
    }

    public StaticDirectory(List<Invoker<T>> invokers, RouterChain<T> routerChain) {
        this(null, invokers, routerChain);
    }

    public StaticDirectory(URL url, List<Invoker<T>> invokers) {
        this(url, invokers, null);
    }

    public StaticDirectory(URL url, List<Invoker<T>> invokers, RouterChain<T> routerChain) {
        super(url == null && CollectionUtils.isNotEmpty(invokers) ? invokers.get(0).getUrl() : url, routerChain, false);
        if (CollectionUtils.isEmpty(invokers)) {
            throw new IllegalArgumentException("invokers == null");
        }
        this.setInvokers(new BitList<Invoker<T>>(invokers));
    }

    @Override
    public Class<T> getInterface() {
        return this.getInvokers().get(0).getInterface();
    }

    @Override
    public List<Invoker<T>> getAllInvokers() {
        return this.getInvokers();
    }

    public boolean isAvailable() {
        if (this.isDestroyed()) {
            return false;
        }
        for (Invoker invoker : this.getValidInvokers()) {
            if (!invoker.isAvailable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        for (Invoker invoker : this.getInvokers()) {
            invoker.destroy();
        }
        super.destroy();
    }

    public void buildRouterChain() {
        RouterChain routerChain = RouterChain.buildChain(this.getInterface(), this.getUrl());
        routerChain.setInvokers(this.getInvokers());
        this.setRouterChain(routerChain);
    }

    public void notify(List<Invoker<T>> invokers) {
        this.setInvokers(new BitList<Invoker<T>>(invokers));
        if (this.routerChain != null) {
            this.routerChain.setInvokers(this.getInvokers());
        }
    }

    @Override
    protected List<Invoker<T>> doList(BitList<Invoker<T>> invokers, Invocation invocation) throws RpcException {
        if (this.routerChain != null) {
            try {
                List<Invoker<T>> finalInvokers = this.routerChain.route(this.getConsumerUrl(), invokers, invocation);
                return finalInvokers == null ? BitList.emptyList() : finalInvokers;
            }
            catch (Throwable t) {
                logger.error("Failed to execute router: " + this.getUrl() + ", cause: " + t.getMessage(), t);
                return BitList.emptyList();
            }
        }
        return invokers;
    }
}

