/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.exception;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapOperationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class LdapAuthenticationNotSupportedException
extends LdapOperationException {
    static final long serialVersionUID = 1L;

    public LdapAuthenticationNotSupportedException(ResultCodeEnum resultCode, String message) {
        super(message);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapAuthenticationNotSupportedException(ResultCodeEnum resultCode) {
        super((String)null);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    private void checkResultCode(ResultCodeEnum resultCode) {
        switch (resultCode) {
            case INAPPROPRIATE_AUTHENTICATION: 
            case CONFIDENTIALITY_REQUIRED: 
            case AUTH_METHOD_NOT_SUPPORTED: {
                return;
            }
        }
        throw new IllegalArgumentException(I18n.err((String)"ERR_04140", (Object[])new Object[]{resultCode}));
    }
}

