/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls;

import org.apache.directory.shared.i18n.I18n;

public class ChangeType {
    public static final int ADD_VALUE = 1;
    public static final int DELETE_VALUE = 2;
    public static final int MODIFY_VALUE = 4;
    public static final int MODDN_VALUE = 8;
    public static final ChangeType ADD = new ChangeType("ADD", 1);
    public static final ChangeType DELETE = new ChangeType("DELETE", 2);
    public static final ChangeType MODIFY = new ChangeType("MODIFY", 4);
    public static final ChangeType MODDN = new ChangeType("MODDN", 8);
    private final String label;
    private final int value;

    private ChangeType(String label, int value) {
        this.label = label;
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.label;
    }

    public static ChangeType getChangeType(int value) {
        switch (value) {
            case 1: {
                return ADD;
            }
            case 2: {
                return DELETE;
            }
            case 4: {
                return MODIFY;
            }
            case 8: {
                return MODDN;
            }
        }
        throw new IllegalArgumentException(I18n.err((String)"ERR_04055", (Object[])new Object[]{value}));
    }
}

