/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;
import net.sourceforge.plantuml.xmi.XmlDiagramTransformer;
import net.sourceforge.plantuml.xml.XmlFactories;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XmiDescriptionDiagramAbstract
implements XmlDiagramTransformer {
    protected final DescriptionDiagram diagram;
    protected final Document document;
    protected final Element ownedElement;

    public XmiDescriptionDiagramAbstract(DescriptionDiagram diagram) throws ParserConfigurationException {
        this.diagram = diagram;
        DocumentBuilder builder = XmlFactories.newDocumentBuilder();
        this.document = builder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        Element xmi = this.document.createElement("XMI");
        xmi.setAttribute("xmi.version", "1.1");
        xmi.setAttribute("xmlns:UML", "href://org.omg/UML/1.3");
        this.document.appendChild(xmi);
        Element header = this.document.createElement("XMI.header");
        xmi.appendChild(header);
        Element metamodel = this.document.createElement("XMI.metamodel");
        metamodel.setAttribute("xmi.name", "UML");
        metamodel.setAttribute("xmi.version", "1.3");
        header.appendChild(metamodel);
        Element content = this.document.createElement("XMI.content");
        xmi.appendChild(content);
        Element model = this.document.createElement("UML:Model");
        model.setAttribute("xmi.id", CucaDiagramXmiMaker.getModel(diagram));
        model.setAttribute("name", "PlantUML");
        content.appendChild(model);
        this.ownedElement = this.document.createElement("UML:Namespace.ownedElement");
        model.appendChild(this.ownedElement);
        for (Entity gr : diagram.getEntityFactory().groups()) {
            if (!gr.getParentContainer().isRoot()) continue;
            this.addElement(gr, this.ownedElement);
        }
        for (Entity ent : diagram.getEntityFactory().leafs()) {
            if (!ent.getParentContainer().isRoot()) continue;
            this.addElement(ent, this.ownedElement);
        }
        for (Link link : diagram.getLinks()) {
            this.addLink(link);
        }
    }

    protected void addElement(Entity tobeAdded, Element container) {
        Element element = this.createEntityNode(tobeAdded);
        container.appendChild(element);
        for (Entity ent : this.diagram.getEntityFactory().groups()) {
            if (ent.getParentContainer() != tobeAdded) continue;
            this.addElement(ent, element);
        }
        for (Entity ent : this.diagram.getEntityFactory().leafs()) {
            if (ent.getParentContainer() != tobeAdded) continue;
            this.addElement(ent, element);
        }
    }

    protected abstract void addLink(Link var1);

    protected Element createEntityNode(Entity entity) {
        Element cla = this.document.createElement("UML:Component");
        cla.setAttribute("xmi.id", entity.getUid());
        cla.setAttribute("name", entity.getDisplay().get(0).toString());
        cla.setAttribute("namespace", CucaDiagramXmiMaker.getModel(this.diagram));
        Element feature = this.document.createElement("UML:Classifier.feature");
        cla.appendChild(feature);
        return cla;
    }

    @Override
    public void transformerXml(OutputStream os) throws TransformerException, ParserConfigurationException {
        DOMSource source = new DOMSource(this.document);
        StreamResult resultat = new StreamResult(os);
        Transformer transformer = XmlFactories.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.transform(source, resultat);
    }

    public static String forXMI(String s) {
        return s.replace(':', ' ');
    }

    public static String forXMI(Display s) {
        return s.get(0).toString().replace(':', ' ');
    }
}

