// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.statediagram;

import java.util.Map;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.skin.UmlDiagramType;

public class StateDiagram extends AbstractEntityDiagram {
	// ::remove folder when __HAXE__

	private static final String CONCURRENT_PREFIX = "CONC";

	public StateDiagram(UmlSource source, Map<String, String> skinParam) {
		super(source, UmlDiagramType.STATE, skinParam);
		setNamespaceSeparator(".");
	}

	public boolean checkConcurrentStateOk(Quark<Entity> code) {
		final boolean result = checkConcurrentStateOkInternal(code);
		return result;
	}

	private boolean checkConcurrentStateOkInternal(Quark<Entity> code) {
		if (code.getData() == null)
			return true;

		final Entity existing = code.getData();
		if (getCurrentGroup().getGroupType() == GroupType.CONCURRENT_STATE
				&& getCurrentGroup() != existing.getParentContainer())
			return false;

		if (existing.getParentContainer() != null
				&& existing.getParentContainer().getGroupType() == GroupType.CONCURRENT_STATE
				&& getCurrentGroup() != existing.getParentContainer())
			return false;

		return true;
	}

	public Entity getStart() {
		final Entity g = getCurrentGroup();
		if (g.isRoot()) {
			final String idShort = "*start*";
			final Quark<Entity> quark = quarkInContext(true, cleanId(idShort));
			if (quark.getData() == null)
				reallyCreateLeaf(quark, Display.getWithNewlines(""), LeafType.CIRCLE_START, null);
			return quark.getData();
		}
		final String idShort = "*start*" + g.getName();
		final Quark<Entity> quark = quarkInContext(true, cleanId(idShort));
		if (quark.getData() == null)
			reallyCreateLeaf(quark, Display.getWithNewlines(""), LeafType.CIRCLE_START, null);
		return quark.getData();
	}

	public Entity getEnd() {
		final Entity p = getCurrentGroup();
		if (p.isRoot()) {
			final String idShort = "*end*";
			final Quark<Entity> quark = quarkInContext(true, cleanId(idShort));
			if (quark.getData() == null)
				reallyCreateLeaf(quark, Display.getWithNewlines(""), LeafType.CIRCLE_END, null);
			return quark.getData();
		}
		final String idShort = "*end*" + p.getName();
		final Quark<Entity> quark = quarkInContext(true, cleanId(idShort));
		if (quark.getData() == null)
			reallyCreateLeaf(quark, Display.getWithNewlines(""), LeafType.CIRCLE_END, null);
		return quark.getData();
	}

	public Entity getHistorical() {
		final Entity g = getCurrentGroup();
		if (g.isRoot()) {
			final String idShort = "*historical*";
			final Quark<Entity> quark = quarkInContext(true, cleanId(idShort));
			if (quark.getData() == null)
				reallyCreateLeaf(quark, Display.getWithNewlines(""), LeafType.PSEUDO_STATE, null);
			return quark.getData();
		}
		final String idShort = "*historical*" + g.getName();
		final Quark<Entity> quark = quarkInContext(true, cleanId(idShort));
		if (quark.getData() == null)
			reallyCreateLeaf(quark, Display.getWithNewlines(""), LeafType.PSEUDO_STATE, null);
		return quark.getData();
	}

	public Entity getHistorical(String idShort) {
		final Quark<Entity> quark = quarkInContext(true, cleanId(idShort));
		gotoGroup(quark, Display.getWithNewlines(quark), GroupType.STATE);
		final Entity g = getCurrentGroup();
		final String tmp = "*historical*" + g.getName();
		final Quark<Entity> ident = quarkInContext(true, tmp);
		final Entity result;
		if (ident.getData() == null)
			result = reallyCreateLeaf(ident, Display.getWithNewlines(ident), LeafType.PSEUDO_STATE, null);
		else
			result = ident.getData();
		endGroup();
		return result;
	}

	public Entity getDeepHistory() {
		final Entity g = getCurrentGroup();
		if (g.isRoot()) {
			final String idShort = "*deephistory*";
			final Quark<Entity> quark = quarkInContext(true, cleanId(idShort));
			if (quark.getData() == null)
				reallyCreateLeaf(quark, Display.getWithNewlines(""), LeafType.DEEP_HISTORY, null);
			return quark.getData();
		}

		final String idShort = "*deephistory*" + g.getName();
		final Quark<Entity> quark = quarkInContext(true, cleanId(idShort));
		if (quark.getData() == null)
			reallyCreateLeaf(quark, Display.getWithNewlines(""), LeafType.DEEP_HISTORY, null);
		return quark.getData();

	}

	public Entity getDeepHistory(String idShort) {
		final Quark<Entity> quark = quarkInContext(true, cleanId(idShort));

		gotoGroup(quark, Display.getWithNewlines(quark), GroupType.STATE);
		final Entity g = getCurrentGroup();
		final String tmp = "*deephistory*" + g.getName();
		final Quark<Entity> ident = quarkInContext(true, cleanId(tmp));
		final Entity result = reallyCreateLeaf(ident, Display.getWithNewlines(""), LeafType.DEEP_HISTORY, null);
		endGroup();
		return result;
	}

	public boolean concurrentState(char direction) {
		final Entity cur = getCurrentGroup();
		getCurrentGroup().setConcurrentSeparator(direction);

		if (cur.getGroupType() == GroupType.CONCURRENT_STATE)
			super.endGroup();

		final String tmp1 = this.getUniqueSequence(CONCURRENT_PREFIX);
		final Quark<Entity> ident1 = quarkInContext(true, cleanId(tmp1));

		gotoGroup(ident1, Display.create(""), GroupType.CONCURRENT_STATE);
		getCurrentGroup().setConcurrentSeparator(direction);
//		// final Entity conc1 = getCurrentGroup();
//		if (cur.getGroupType() == GroupType.STATE) {
//
////			moveAllChildOfToAnewFather(cur.getQuark(), conc1.getQuark());
////			super.endGroup();
//
//			final String tmp2 = this.getUniqueSequence(CONCURRENT_PREFIX);
//			final Quark<Entity> ident2 = quarkInContext(tmp2, false);
//			gotoGroup(ident2, Display.create(""), GroupType.CONCURRENT_STATE);
//		}

		return true;
	}

	@Override
	public boolean endGroup() {
		final Entity cur = getCurrentGroup();
		if (cur.getGroupType() == GroupType.CONCURRENT_STATE)
			super.endGroup();

		return super.endGroup();
	}

	private boolean hideEmptyDescription = false;

	@Override
	public final void setHideEmptyDescription(boolean hideEmptyDescription) {
		this.hideEmptyDescription = hideEmptyDescription;
	}

	public final boolean isHideEmptyDescriptionForState() {
		return hideEmptyDescription;
	}

	@Override
	public String checkFinalError() {
		for (Link link : this.getLinks()) {
			final Entity parent1 = getGroupParentIfItIsConcurrentState(link.getEntity1());
			final Entity parent2 = getGroupParentIfItIsConcurrentState(link.getEntity2());
			if (isCompatible(parent1, parent2) == false)
				return "State within concurrent state cannot be linked out of this concurrent state (between "
						+ link.getEntity1().getName() + " and " + link.getEntity2().getName() + ")";

		}
		return super.checkFinalError();
	}

	private static boolean isCompatible(Entity parent1, Entity parent2) {
		if (parent1 == null && parent2 == null)
			return true;

		if (parent1 != null ^ parent2 != null)
			return false;

		assert parent1 != null && parent2 != null;
		return parent1 == parent2;
	}

	private static Entity getGroupParentIfItIsConcurrentState(Entity ent) {
		Entity parent = ent.getParentContainer();
		while (parent != null) {
			if (parent.getGroupType() == GroupType.CONCURRENT_STATE)
				return parent;

			parent = parent.getParentContainer();
		}
		return null;

	}

}
