// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowDressing;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.Style;

public class ComponentRoseArrow extends AbstractComponentRoseArrow {

	private final HorizontalAlignment messagePosition;
	private final boolean niceArrow;
	private final boolean belowForResponse;
	private final int inclination1;
	private final int inclination2;

	public ComponentRoseArrow(Style style, Display stringsToDisplay, ArrowConfiguration arrowConfiguration,
			HorizontalAlignment messagePosition, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize,
			boolean niceArrow, boolean belowForResponse) {
		super(style, stringsToDisplay, arrowConfiguration, spriteContainer, maxMessageSize);
		this.messagePosition = messagePosition;
		this.niceArrow = niceArrow;
		this.belowForResponse = belowForResponse;
		this.inclination1 = arrowConfiguration.getInclination1();
		this.inclination2 = arrowConfiguration.getInclination2();
	}

	public static final double spaceCrossX = 6;
	public static final double diamCircle = 8;
	public static final double thinCircle = 1.5;

	@Override
	public void drawInternalU(UGraphic ug, Area area) {
		final ArrowConfiguration arrowConfiguration = getArrowConfiguration();
		if (arrowConfiguration.isHidden())
			return;

		final XDimension2D dimensionToUse = area.getDimensionToUse();
		final StringBounder stringBounder = ug.getStringBounder();
		ug = ug.apply(getForegroundColor());

		final ArrowDressing dressing1 = arrowConfiguration.getDressing1();
		final ArrowDressing dressing2 = arrowConfiguration.getDressing2();

		double start = 0;
		double len = dimensionToUse.getWidth() - 1;
		final double lenFull = dimensionToUse.getWidth();

		final double pos1 = start + 1;
		final double pos2 = len - 1;

		if (arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && dressing2.getHead() == ArrowHead.NONE)
			len -= diamCircle / 2;

		if (arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && dressing2.getHead() != ArrowHead.NONE)
			len -= diamCircle / 2 + thinCircle;

		if (arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && dressing1.getHead() == ArrowHead.NONE) {
			start += diamCircle / 2;
			len -= diamCircle / 2;
		}
		if (arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && dressing1.getHead() == ArrowHead.NORMAL) {
			start += diamCircle + thinCircle;
			len -= diamCircle + thinCircle;
		}

		if (dressing2.getPart() == ArrowPart.FULL && dressing2.getHead() == ArrowHead.NORMAL)
			len -= getArrowDeltaX() / 2;

		if (dressing1.getPart() == ArrowPart.FULL && dressing1.getHead() == ArrowHead.NORMAL) {
			start += getArrowDeltaX() / 2;
			len -= getArrowDeltaX() / 2;
		}

		if (dressing2.getHead() == ArrowHead.CROSSX)
			len -= 2 * spaceCrossX;

		if (dressing1.getHead() == ArrowHead.CROSSX) {
			start += 2 * spaceCrossX;
			len -= 2 * spaceCrossX;
		}

		final double posArrow;
		final double yText;
		if (isBelowForResponse()) {
			posArrow = 0;
			yText = getMarginY();
		} else {
			posArrow = getTextHeight(stringBounder);
			yText = 0;
		}

		drawDressing1(ug.apply(new UTranslate(pos1, posArrow + inclination1)), dressing1,
				arrowConfiguration.getDecoration1(), lenFull);
		drawDressing2(ug.apply(new UTranslate(pos2, posArrow + inclination2)), dressing2,
				arrowConfiguration.getDecoration2(), lenFull);

		if (inclination1 == 0 && inclination2 == 0)
			arrowConfiguration.applyStroke(ug).apply(new UTranslate(start, posArrow)).draw(new ULine(len, 0));
		else if (inclination1 != 0)
			drawLine(arrowConfiguration.applyStroke(ug), start + len, posArrow, 0, posArrow + inclination1);
		else if (inclination2 != 0)
			drawLine(arrowConfiguration.applyStroke(ug), start, posArrow, pos2, posArrow + inclination2);

		final ArrowDirection direction2 = getDirection2();
		final double textPos;
		if (messagePosition == HorizontalAlignment.CENTER) {
			final double textWidth = getTextBlock().calculateDimension(stringBounder).getWidth();
			textPos = (dimensionToUse.getWidth() - textWidth) / 2;
		} else if (messagePosition == HorizontalAlignment.RIGHT) {
			final double textWidth = getTextBlock().calculateDimension(stringBounder).getWidth();
			textPos = dimensionToUse.getWidth() - textWidth - getMarginX2()
					- (direction2 == ArrowDirection.LEFT_TO_RIGHT_NORMAL ? getArrowDeltaX() : 0);
		} else {
			textPos = getMarginX1()
					+ (direction2 == ArrowDirection.RIGHT_TO_LEFT_REVERSE || direction2 == ArrowDirection.BOTH_DIRECTION
							? getArrowDeltaX()
							: 0);
		}
		getTextBlock().drawU(ug.apply(new UTranslate(textPos, yText)));
	}

	private void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
		ug = ug.apply(new UTranslate(x1, y1));
		ug.draw(new ULine(x2 - x1, y2 - y1));

	}

	public double getPosArrow(StringBounder stringBounder) {
		if (isBelowForResponse())
			return 0;

		return getTextHeight(stringBounder) - 2 * getMarginY();
	}

	private boolean isBelowForResponse() {
		return belowForResponse && getArrowConfiguration().isReverseDefine();
	}

	private void drawDressing1(UGraphic ug, ArrowDressing dressing, ArrowDecoration decoration, double lenFull) {

		if (decoration == ArrowDecoration.CIRCLE) {
			final UEllipse circle = UEllipse.build(diamCircle, diamCircle);
			ug.apply(UStroke.withThickness(thinCircle)).apply(getForegroundColor())
					.apply(new UTranslate(-diamCircle / 2 - thinCircle, -diamCircle / 2 - thinCircle / 2)).draw(circle);
			if (dressing.getHead() != ArrowHead.CROSSX)
				ug = ug.apply(UTranslate.dx(diamCircle / 2 + thinCircle));
		}

		if (dressing.getHead() == ArrowHead.ASYNC) {
			if (dressing.getPart() != ArrowPart.BOTTOM_PART)
				getArrowConfiguration().applyThicknessOnly(ug).draw(
						new ULine(getArrowDeltaX(), -getArrowDeltaY()).rotate(Math.atan2(-inclination1, lenFull)));

			if (dressing.getPart() != ArrowPart.TOP_PART)
				getArrowConfiguration().applyThicknessOnly(ug)
						.draw(new ULine(getArrowDeltaX(), getArrowDeltaY()).rotate(Math.atan2(-inclination1, lenFull)));

		} else if (dressing.getHead() == ArrowHead.CROSSX) {
			ug = ug.apply(UStroke.withThickness(2));
			ug.apply(new UTranslate(spaceCrossX, -getArrowDeltaX() / 2))
					.draw(new ULine(getArrowDeltaX(), getArrowDeltaX()));
			ug.apply(new UTranslate(spaceCrossX, getArrowDeltaX() / 2))
					.draw(new ULine(getArrowDeltaX(), -getArrowDeltaX()));
		} else if (dressing.getHead() == ArrowHead.NORMAL) {
			final UPolygon polygon = getPolygonReverse(dressing.getPart());

			if (inclination1 != 0)
				polygon.rotate(Math.atan2(-inclination1, lenFull));

			ug.apply(getForegroundColor().bg()).draw(polygon);
		}

	}

	private void drawDressing2(UGraphic ug, ArrowDressing dressing, ArrowDecoration decoration, double lenFull) {

		if (decoration == ArrowDecoration.CIRCLE) {
			ug = ug.apply(UStroke.withThickness(thinCircle)).apply(getForegroundColor());
			final UEllipse circle = UEllipse.build(diamCircle, diamCircle);
			ug.apply(new UTranslate(-diamCircle / 2 + thinCircle, -diamCircle / 2 - thinCircle / 2)).draw(circle);
			ug = ug.apply(UStroke.simple());
			ug = ug.apply(UTranslate.dx(-diamCircle / 2 - thinCircle));
		}

		if (dressing.getHead() == ArrowHead.ASYNC) {
			if (dressing.getPart() != ArrowPart.BOTTOM_PART)
				getArrowConfiguration().applyThicknessOnly(ug).draw(
						new ULine(-getArrowDeltaX(), -getArrowDeltaY()).rotate(Math.atan2(inclination2, lenFull)));

			if (dressing.getPart() != ArrowPart.TOP_PART)
				getArrowConfiguration().applyThicknessOnly(ug)
						.draw(new ULine(-getArrowDeltaX(), getArrowDeltaY()).rotate(Math.atan2(inclination2, lenFull)));

		} else if (dressing.getHead() == ArrowHead.CROSSX) {
			ug = ug.apply(UStroke.withThickness(2));
			ug.apply(new UTranslate(-spaceCrossX - getArrowDeltaX(), -getArrowDeltaX() / 2))
					.draw(new ULine(getArrowDeltaX(), getArrowDeltaX()));
			ug.apply(new UTranslate(-spaceCrossX - getArrowDeltaX(), getArrowDeltaX() / 2))
					.draw(new ULine(getArrowDeltaX(), -getArrowDeltaX()));
		} else if (dressing.getHead() == ArrowHead.NORMAL) {
			final UPolygon polygon = getPolygonNormal(dressing.getPart());

			if (inclination2 != 0)
				polygon.rotate(Math.atan2(inclination2, lenFull));

			ug.apply(getForegroundColor().bg()).draw(polygon);
		}

	}

	private UPolygon getPolygonNormal(ArrowPart part) {
		UPolygon polygon = new UPolygon();
		if (part == ArrowPart.TOP_PART) {
			polygon.addPoint(-getArrowDeltaX(), -getArrowDeltaY());
			polygon.addPoint(0, 0);
			polygon.addPoint(-getArrowDeltaX(), 0);
		} else if (part == ArrowPart.BOTTOM_PART) {
			polygon.addPoint(-getArrowDeltaX(), 1);
			polygon.addPoint(0, 1);
			polygon.addPoint(-getArrowDeltaX(), getArrowDeltaY() + 1);
		} else {
			polygon.addPoint(-getArrowDeltaX(), -getArrowDeltaY());
			polygon.addPoint(0, 0);
			polygon.addPoint(-getArrowDeltaX(), +getArrowDeltaY());
			if (niceArrow)
				polygon.addPoint(-getArrowDeltaX() + 4, 0);
		}
		return polygon;
	}

	private UPolygon getPolygonReverse(ArrowPart part) {
		final UPolygon polygon = new UPolygon();
		if (part == ArrowPart.TOP_PART) {
			polygon.addPoint(getArrowDeltaX(), -getArrowDeltaY());
			polygon.addPoint(0, 0);
			polygon.addPoint(getArrowDeltaX(), 0);
		} else if (part == ArrowPart.BOTTOM_PART) {
			polygon.addPoint(getArrowDeltaX(), 1);
			polygon.addPoint(0, 1);
			polygon.addPoint(getArrowDeltaX(), getArrowDeltaY() + 1);
		} else {
			polygon.addPoint(getArrowDeltaX(), -getArrowDeltaY());
			polygon.addPoint(0, 0);
			polygon.addPoint(getArrowDeltaX(), getArrowDeltaY());
			if (niceArrow)
				polygon.addPoint(getArrowDeltaX() - 4, 0);

		}
		return polygon;
	}

	public XPoint2D getStartPoint(StringBounder stringBounder, XDimension2D dimensionToUse) {
		final double y = getYPoint(stringBounder);
		if (getDirection2() == ArrowDirection.LEFT_TO_RIGHT_NORMAL)
			return new XPoint2D(getPaddingX(), y + inclination2);

		return new XPoint2D(dimensionToUse.getWidth() + getPaddingX(), y + inclination2);
	}

	public XPoint2D getEndPoint(StringBounder stringBounder, XDimension2D dimensionToUse) {
		final double y = getYPoint(stringBounder);
		if (getDirection2() == ArrowDirection.LEFT_TO_RIGHT_NORMAL)
			return new XPoint2D(dimensionToUse.getWidth() + getPaddingX(), y);

		return new XPoint2D(getPaddingX(), y);
	}

	@Override
	public double getYPoint(StringBounder stringBounder) {
		if (isBelowForResponse())
			return getPaddingY();

		return getTextHeight(stringBounder) + getPaddingY();
	}

	final private ArrowDirection getDirection2() {
		return getArrowConfiguration().getArrowDirection();
	}

	@Override
	public double getPreferredHeight(StringBounder stringBounder) {
		return getTextHeight(stringBounder) + getArrowDeltaY() + 2 * getPaddingY() + inclination1 + inclination2;
	}

	@Override
	public double getPreferredWidth(StringBounder stringBounder) {
		return getTextWidth(stringBounder) + getArrowDeltaX();
	}

}
