// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.klimt.drawing.visio;

import java.io.IOException;
import java.io.OutputStream;

public class VisioText implements VisioShape {

	private final int id;
	private final String text;
	private final int fontSize;
	private final double x;
	private final double y;
	private final double width;
	private final double height;

	private final double coefFont = 150.0;

	public static VisioText createInches(int id, String text, int fontSize, double x, double y, double width,
			double height) {
		final double coef = 1.8;
		return new VisioText(id, text, fontSize, toInches(x), toInches(y + 2.5), toInches(width * coef),
				toInches(height * coef));
	}

	private static double toInches(double val) {
		return val / 72.0;
	}

	private VisioText(int id, String text, int fontSize, double x, double y, double width, double height) {
		this.id = id;
		this.text = text;
		this.x = x;
		this.y = y;
		this.height = height;
		this.width = width;
		this.fontSize = fontSize;
	}

	public void print(OutputStream os) throws IOException {
		out(os, "<Shape ID='" + id + "' Type='Shape' LineStyle='1' FillStyle='1' TextStyle='3'>");
		out(os, "<XForm>");
		out(os, "<PinX>" + x + "</PinX>");
		out(os, "<PinY>" + y + "</PinY>");
		out(os, "<Width>" + width + "</Width>");
		out(os, "<Height>" + height + "</Height>");
		// out(os, "<PinX>1.0625</PinX>");
		// out(os, "<PinY>1.9375</PinY>");
		out(os, "<LocPinX F='Width*0'>0</LocPinX>");
		out(os, "<LocPinY F='Height*0'>0</LocPinY>");
		out(os, "<Angle>0</Angle>");
		out(os, "<FlipX>0</FlipX>");
		out(os, "<FlipY>0</FlipY>");
		out(os, "<ResizeMode>0</ResizeMode>");
		out(os, "</XForm>");
		out(os, "<TextBlock>");
		out(os, "<VerticalAlign>0</VerticalAlign>");
		out(os, "</TextBlock>");
		out(os, "<Char IX='" + id + "'>");
		out(os, "<Font F='Inh'>0</Font>");
		out(os, "<Color F='Inh'>0</Color>");
		out(os, "<Style F='Inh'>0</Style>");
		out(os, "<Case F='Inh'>0</Case>");
		out(os, "<Pos F='Inh'>0</Pos>");
		out(os, "<FontScale F='Inh'>1</FontScale>");
		out(os, "<Locale F='Inh'>0</Locale>");
		out(os, "<Size Unit='PT'>" + fontSize / coefFont + "</Size>");
		out(os, "<DblUnderline F='Inh'>0</DblUnderline>");
		out(os, "<Overline F='Inh'>0</Overline>");
		out(os, "<Strikethru F='Inh'>0</Strikethru>");
		out(os, "<Perpendicular F='Inh'>0</Perpendicular>");
		out(os, "<Letterspace F='Inh'>0</Letterspace>");
		out(os, "<ColorTrans F='Inh'>0</ColorTrans>");
		out(os, "</Char>");

		out(os, "<Para IX='" + id + "'>");
		out(os, "<HorzAlign>0</HorzAlign>");
		out(os, "</Para>");

		out(os, "<Text><cp IX='" + id + "'/><pp IX='" + id + "'/>" + text + "</Text>");
		out(os, "</Shape>");

	}

	public VisioShape yReverse(double maxY) {
		final double y2 = maxY - y;
		return new VisioText(id, text, fontSize, x, y2, width, height);
	}

	private void out(OutputStream os, String s) throws IOException {
		os.write(s.getBytes());
		os.write("\n".getBytes());
	}

}
