// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.klimt.CopyForegroundColorToBackgroundColor;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public abstract class ETile extends AbstractTextBlock {

	protected final boolean TRACE = false;

	public static StyleSignatureBasic getStyleSignature() {
		return StyleSignatureBasic.of(SName.root, SName.element, SName.ebnf);
	}

	public abstract void push(ETile tile);

	@Override
	final public XDimension2D calculateDimension(StringBounder stringBounder) {
		final double width = getWidth(stringBounder);
		final double h1 = getH1(stringBounder);
		final double h2 = getH2(stringBounder);
		return new XDimension2D(width, h1 + h2);
	}

	public abstract double getWidth(StringBounder stringBounder);

	public abstract double getH1(StringBounder stringBounder);

	public abstract double getH2(StringBounder stringBounder);

	protected final void drawHline(UGraphic ug, double y, double x1, double x2) {
		ug.apply(new UTranslate(x1, y)).draw(ULine.hline(x2 - x1));
	}

	protected final void drawHlineDirected(UGraphic ug, double y, double x1, double x2, double coef) {
		ug.apply(new UTranslate(x1, y)).draw(ULine.hline(x2 - x1));
		if (x2 > x1 + 25)
			ug.apply(new CopyForegroundColorToBackgroundColor())
					.apply(new UTranslate(x1 * (1 - coef) + x2 * coef - 2, y)).draw(getArrowToRight());

	}

	protected final void drawHlineAntiDirected(UGraphic ug, double y, double x1, double x2, double coef) {
		ug.apply(new UTranslate(x1, y)).draw(ULine.hline(x2 - x1));
		ug.apply(new CopyForegroundColorToBackgroundColor()).apply(new UTranslate(x1 * (1 - coef) + x2 * coef - 2, y))
				.draw(getArrowToLeft());

	}

	protected final void drawVline(UGraphic ug, double x, double y1, double y2) {
		ug.apply(new UTranslate(x, y1)).draw(ULine.vline(y2 - y1));
	}

	protected final void drawVlineDirected(UGraphic ug, double x, double y1, double y2) {
		ug.apply(new UTranslate(x, y1)).draw(ULine.vline(y2 - y1));
		ug.apply(new CopyForegroundColorToBackgroundColor()).apply(new UTranslate(x, y1 * .5 + y2 * .5 - 2))
				.draw(getArrowToBottom());

	}

	protected final void drawVlineAntiDirected(UGraphic ug, double x, double y1, double y2) {
		ug.apply(new UTranslate(x, y1)).draw(ULine.vline(y2 - y1));
		ug.apply(new CopyForegroundColorToBackgroundColor()).apply(new UTranslate(x, y1 * .5 + y2 * .5 + 2))
				.draw(getArrowToTop());

	}

	static UPath getArrowToLeft() {
		final UPath arrow = UPath.none();
		arrow.moveTo(0, 0);
		arrow.lineTo(0, -3);
		arrow.lineTo(-6, 0);
		arrow.lineTo(0, 3);
		arrow.lineTo(0, 0);
		arrow.closePath();
		return arrow;
	}

	static UPath getArrowToRight() {
		final UPath arrow = UPath.none();
		arrow.moveTo(0, 0);
		arrow.lineTo(0, -3);
		arrow.lineTo(6, 0);
		arrow.lineTo(0, 3);
		arrow.lineTo(0, 0);
		arrow.closePath();
		return arrow;
	}

	static UPath getArrowToBottom() {
		final UPath arrow = UPath.none();
		arrow.moveTo(0, 0);
		arrow.lineTo(3, 0);
		arrow.lineTo(0, 6);
		arrow.lineTo(-3, 0);
		arrow.lineTo(0, 0);
		arrow.closePath();
		return arrow;
	}

	static UPath getArrowToTop() {
		final UPath arrow = UPath.none();
		arrow.moveTo(0, 0);
		arrow.lineTo(3, 0);
		arrow.lineTo(0, -6);
		arrow.lineTo(-3, 0);
		arrow.lineTo(0, 0);
		arrow.closePath();
		return arrow;
	}

	protected void addCommentBelow(String comment) {
		System.err.println("Ignoring below comment " + comment + " " + getClass());
	}

	protected void addCommentAbove(String comment) {
		System.err.println("Ignoring above comment " + comment + " " + getClass());
	}

	protected String getRepetitionLabel() {
		return "?";
	}

}
