// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */

package net.sourceforge.plantuml.brotli;

import java.nio.ByteBuffer;

/**
 * Transformations on dictionary words.
 */
final class Transform {

	static final int NUM_TRANSFORMS = 121;
	private static final int[] TRANSFORMS = new int[NUM_TRANSFORMS * 3];
	private static final byte[] PREFIX_SUFFIX = new byte[217];
	private static final int[] PREFIX_SUFFIX_HEADS = new int[51];

	// Bundle of 0-terminated strings.
	private static final String PREFIX_SUFFIX_SRC = "# #s #, #e #.# the #.com/#\u00C2\u00A0# of # and"
			+ " # in # to #\"#\">#\n#]# for # a # that #. # with #'# from # by #. The # on # as # is #ing"
			+ " #\n\t#:#ed #(# at #ly #=\"# of the #. This #,# not #er #al #='#ful #ive #less #est #ize #" + "ous #";
	private static final String TRANSFORMS_SRC = "     !! ! ,  *!  &!  \" !  ) *   * -  ! # !  #!*!  "
			+ "+  ,$ !  -  %  .  / #   0  1 .  \"   2  3!*   4%  ! # /   5  6  7  8 0  1 &   $   9 +   : "
			+ " ;  < '  !=  >  ?! 4  @ 4  2  &   A *# (   B  C& ) %  ) !*# *-% A +! *.  D! %'  & E *6  F "
			+ " G% ! *A *%  H! D  I!+!  J!+   K +- *4! A  L!*4  M  N +6  O!*% +.! K *G  P +%(  ! G *D +D "
			+ " Q +# *K!*G!+D!+# +G +A +4!+% +K!+4!*D!+K!*K";

	private static void unpackTransforms(byte[] prefixSuffix, int[] prefixSuffixHeads, int[] transforms,
			String prefixSuffixSrc, String transformsSrc) {
		int n = prefixSuffixSrc.length();
		int index = 1;
		for (int i = 0; i < n; ++i) {
			char c = prefixSuffixSrc.charAt(i);
			prefixSuffix[i] = (byte) c;
			if (c == 35) { // == #
				prefixSuffixHeads[index++] = i + 1;
				prefixSuffix[i] = 0;
			}
		}

		for (int i = 0; i < NUM_TRANSFORMS * 3; ++i) {
			transforms[i] = transformsSrc.charAt(i) - 32;
		}
	}

	static {
		unpackTransforms(PREFIX_SUFFIX, PREFIX_SUFFIX_HEADS, TRANSFORMS, PREFIX_SUFFIX_SRC, TRANSFORMS_SRC);
	}

	static int transformDictionaryWord(byte[] dst, int dstOffset, ByteBuffer data, int wordOffset, int len,
			int transformIndex) {
		int offset = dstOffset;
		int transformOffset = 3 * transformIndex;
		int transformPrefix = PREFIX_SUFFIX_HEADS[TRANSFORMS[transformOffset]];
		int transformType = TRANSFORMS[transformOffset + 1];
		int transformSuffix = PREFIX_SUFFIX_HEADS[TRANSFORMS[transformOffset + 2]];

		// Copy prefix.
		while (PREFIX_SUFFIX[transformPrefix] != 0) {
			dst[offset++] = PREFIX_SUFFIX[transformPrefix++];
		}

		// Copy trimmed word.
		int omitFirst = transformType >= 12 ? (transformType - 11) : 0;
		if (omitFirst > len) {
			omitFirst = len;
		}
		wordOffset += omitFirst;
		len -= omitFirst;
		len -= transformType <= 9 ? transformType : 0; // Omit last.
		int i = len;
		while (i > 0) {
			dst[offset++] = data.get(wordOffset++);
			i--;
		}

		// Ferment.
		if (transformType == 11 || transformType == 10) {
			int uppercaseOffset = offset - len;
			if (transformType == 10) {
				len = 1;
			}
			while (len > 0) {
				int tmp = dst[uppercaseOffset] & 0xFF;
				if (tmp < 0xc0) {
					if (tmp >= 97 && tmp <= 122) { // in [a..z] range
						dst[uppercaseOffset] ^= (byte) 32;
					}
					uppercaseOffset += 1;
					len -= 1;
				} else if (tmp < 0xe0) {
					dst[uppercaseOffset + 1] ^= (byte) 32;
					uppercaseOffset += 2;
					len -= 2;
				} else {
					dst[uppercaseOffset + 2] ^= (byte) 5;
					uppercaseOffset += 3;
					len -= 3;
				}
			}
		}

		// Copy suffix.
		while (PREFIX_SUFFIX[transformSuffix] != 0) {
			dst[offset++] = PREFIX_SUFFIX[transformSuffix++];
		}

		return offset - dstOffset;
	}
}
