// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package gen.lib.pathplan;
import static smetana.core.debug.SmetanaDebug.ENTERING;
import static smetana.core.debug.SmetanaDebug.LEAVING;

import gen.annotation.Original;
import gen.annotation.Unused;

public class solvers__c {


//3 2rap7a11ad4ugnphkh9gbn4xl
// int solve3(double *coeff, double *roots) 
@Unused
@Original(version="2.38.0", path="lib/pathplan/solvers.c", name="solve3", key="2rap7a11ad4ugnphkh9gbn4xl", definition="int solve3(double *coeff, double *roots)")
public static int solve3(double coeff[], double roots[]) {
ENTERING("2rap7a11ad4ugnphkh9gbn4xl","solve3");
try {
    double a, b, c, d;
    int rootn, i;
    double p, q, disc, b_over_3a, c_over_a, d_over_a;
    double r, theta, temp, alpha, beta;
    a = coeff[3]; b = coeff[2]; c = coeff[1]; d = coeff[0];
    if ((((a) < 1E-7) && ((a) > -1E-7)))
	return solve2(coeff, roots);
    b_over_3a = b / (3 * a);
    c_over_a = c / a;
    d_over_a = d / a;
    p = b_over_3a * b_over_3a;
    q = 2 * b_over_3a * p - b_over_3a * c_over_a + d_over_a;
    p = c_over_a / 3 - p;
    disc = q * q + 4 * p * p * p;
    if (disc < 0) {
	r = .5 * Math.sqrt(-disc + q * q);
	theta = Math.atan2(Math.sqrt(-disc), -q);
	temp = 2 * ((r < 0) ? (-1*Math.pow(-r, 1.0/3.0)) : Math.pow(r, 1.0/3.0));
	roots[0] = temp * Math.cos(theta / 3);
	roots[1] = temp * Math.cos((theta + 3.14159265358979323846 + 3.14159265358979323846) / 3);
	roots[2] = temp * Math.cos((theta - 3.14159265358979323846 - 3.14159265358979323846) / 3);
	rootn = 3;
    } else {
	alpha = .5 * (Math.sqrt(disc) - q);
	beta = -q - alpha;
	roots[0] = ((alpha < 0) ? (-1*Math.pow(-alpha, 1.0/3.0)) : Math.pow(alpha, 1.0/3.0)) + ((beta < 0) ? (-1*Math.pow(-beta, 1.0/3.0)) : Math.pow(beta, 1.0/3.0));
	if (disc > 0)
	    rootn = 1;
	else
	    {roots[1] = roots[2] = -.5 * roots[0]; rootn = 3;}
    }
    for (i = 0; i < rootn; i++)
	roots[i] -= b_over_3a;
    return rootn;
} finally {
LEAVING("2rap7a11ad4ugnphkh9gbn4xl","solve3");
}
}




//3 9b5238tdddphds1x726z0osdm
// int solve2(double *coeff, double *roots) 
@Unused
@Original(version="2.38.0", path="lib/pathplan/solvers.c", name="solve2", key="9b5238tdddphds1x726z0osdm", definition="int solve2(double *coeff, double *roots)")
public static int solve2(double coeff[], double roots[]) {
ENTERING("9b5238tdddphds1x726z0osdm","solve2");
try {
    double a, b, c;
    double disc, b_over_2a, c_over_a;
    a = coeff[2]; b = coeff[1]; c = coeff[0];
    if ((((a) < 1E-7) && ((a) > -1E-7)))
	return solve1(coeff, roots);
    b_over_2a = b / (2 * a);
    c_over_a = c / a;
    disc = b_over_2a * b_over_2a - c_over_a;
    if (disc < 0)
	return 0;
    else if (disc == 0) {
	roots[0] = -b_over_2a;
	return 1;
    } else {
	roots[0] = -b_over_2a + Math.sqrt(disc);
	roots[1] = -2 * b_over_2a - roots[0];
	return 2;
    }
} finally {
LEAVING("9b5238tdddphds1x726z0osdm","solve2");
}
}




//3 8xtqt7j6wyxc1b6tj0qtcu1rd
// int solve1(double *coeff, double *roots) 
@Unused
@Original(version="2.38.0", path="lib/pathplan/solvers.c", name="solve1", key="8xtqt7j6wyxc1b6tj0qtcu1rd", definition="int solve1(double *coeff, double *roots)")
public static int solve1(double coeff[], double roots[]) {
ENTERING("8xtqt7j6wyxc1b6tj0qtcu1rd","solve1");
try {
    double a, b;
    a = coeff[1]; b = coeff[0];
    if ((((a) < 1E-7) && ((a) > -1E-7))) {
	if ((((b) < 1E-7) && ((b) > -1E-7)))
	    return 4;
	else
	    return 0;
    }
    roots[0] = -b / a;
    return 1;
} finally {
LEAVING("8xtqt7j6wyxc1b6tj0qtcu1rd","solve1");
}
}


}
