/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.mitm.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.CharStreams;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import net.lightbody.bmp.mitm.TrustSource;
import net.lightbody.bmp.mitm.exception.SslContextInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslUtil {
    private static final Logger log = LoggerFactory.getLogger(SslUtil.class);
    private static final String DEFAULT_CIPHERS_LIST_RESOURCE = "/default-ciphers.txt";
    private static final Supplier<List<String>> defaultCipherList = Suppliers.memoize((Supplier)new Supplier<List<String>>(){

        public List<String> get() {
            List<String> ciphers;
            if (OpenSsl.isAvailable()) {
                ciphers = SslUtil.getBuiltInCipherList();
            } else {
                ciphers = SslUtil.getEnabledJdkCipherSuites();
                if (ciphers.isEmpty()) {
                    ciphers = SslUtil.getBuiltInCipherList();
                }
            }
            return ciphers;
        }
    });

    public static SslContext getUpstreamServerSslContext(Collection<String> cipherSuites, TrustSource trustSource) {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
        if (trustSource == null) {
            log.warn("Disabling upstream server certificate verification. This will allow attackers to intercept communications with upstream servers.");
            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else {
            sslContextBuilder.trustManager(trustSource.getTrustedCAs());
        }
        sslContextBuilder.ciphers(cipherSuites, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
        try {
            return sslContextBuilder.build();
        }
        catch (SSLException e) {
            throw new SslContextInitializationException("Error creating new SSL context for connection to upstream server", e);
        }
    }

    public static X509Certificate getServerCertificate(SSLSession sslSession) {
        Certificate peerCertificate;
        Certificate[] peerCertificates;
        try {
            peerCertificates = sslSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            peerCertificates = null;
        }
        if (peerCertificates != null && peerCertificates.length > 0 && (peerCertificate = peerCertificates[0]) != null && peerCertificate instanceof X509Certificate) {
            return (X509Certificate)peerCertificates[0];
        }
        return null;
    }

    public static List<String> getEnabledJdkCipherSuites() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            String[] defaultCiphers = sslContext.getServerSocketFactory().getDefaultCipherSuites();
            return Arrays.asList(defaultCiphers);
        }
        catch (Throwable t) {
            log.info("Unable to load default JDK server cipher list from SSLContext");
            log.debug("An error occurred while initializing an SSLContext or ServerSocketFactory", t);
            return Collections.emptyList();
        }
    }

    public static List<String> getDefaultCipherList() {
        return (List)defaultCipherList.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getBuiltInCipherList() {
        try {
            Throwable throwable = null;
            Object var1_2 = null;
            try {
                List<String> list;
                InputStream cipherListStream = SslUtil.class.getResourceAsStream(DEFAULT_CIPHERS_LIST_RESOURCE);
                try {
                    if (cipherListStream == null) {
                        list = Collections.emptyList();
                        return list;
                    }
                    InputStreamReader reader = new InputStreamReader(cipherListStream, StandardCharsets.UTF_8);
                    return CharStreams.readLines((Readable)reader);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (cipherListStream == null) return list;
                    cipherListStream.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }
}

