/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.schema.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.async.ResponseParser;
import io.weaviate.client.base.util.DbVersionSupport;
import io.weaviate.client.base.util.UrlEncoder;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.schema.model.Tenant;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpResponse;

public class TenantsUpdater
extends AsyncBaseClient<Boolean>
implements AsyncClientResult<Boolean> {
    private static final int BATCH_SIZE = 100;
    private final DbVersionSupport dbVersionSupport;
    private String className;
    private Tenant[] tenants;

    public TenantsUpdater(CloseableHttpAsyncClient client, Config config, AccessTokenProvider tokenProvider, DbVersionSupport dbVersionSupport) {
        super(client, config, tokenProvider);
        this.dbVersionSupport = dbVersionSupport;
    }

    public TenantsUpdater withClassName(String className) {
        this.className = className;
        return this;
    }

    public TenantsUpdater withTenants(Tenant ... tenants) {
        this.tenants = tenants;
        return this;
    }

    @Override
    public Future<Result<Boolean>> run(FutureCallback<Result<Boolean>> callback) {
        if (this.dbVersionSupport.supportsOnly100TenantsInOneRequest() && this.tenants != null && this.tenants.length > 100) {
            CompletionStage updateAll = CompletableFuture.supplyAsync(() -> this.chunkTenants(this.tenants, 100)).thenApplyAsync(tenants -> {
                for (List batch : tenants) {
                    try {
                        Result<Boolean> resp = this.updateTenants(batch.toArray(new Tenant[0]), null).get();
                        if (!resp.hasErrors()) continue;
                        return resp;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new CompletionException(e);
                    }
                }
                return new Result<Boolean>(200, true, null);
            });
            if (callback != null) {
                return ((CompletableFuture)updateAll).whenComplete((booleanResult, e) -> {
                    callback.completed(booleanResult);
                    if (e != null) {
                        callback.failed(new Exception((Throwable)e));
                    }
                });
            }
            return updateAll;
        }
        return this.updateTenants(this.tenants, callback);
    }

    private Future<Result<Boolean>> updateTenants(Tenant[] tenants, FutureCallback<Result<Boolean>> callback) {
        String path = String.format("/schema/%s/tenants", UrlEncoder.encodePathParam(this.className));
        return this.sendPutRequest(path, (Object)tenants, callback, new ResponseParser<Boolean>(){

            @Override
            public Result<Boolean> parse(HttpResponse response, String body, ContentType contentType) {
                Response<Tenant[]> resp = this.serializer.toResponse(response.getCode(), body, Tenant[].class);
                return new Result<Boolean>(resp.getStatusCode(), resp.getStatusCode() == 200, resp.getErrors());
            }
        });
    }

    private Collection<List<Tenant>> chunkTenants(Tenant[] tenants, int chunkSize) {
        AtomicInteger counter = new AtomicInteger();
        return Stream.of(tenants).collect(Collectors.groupingBy(it -> counter.getAndIncrement() / chunkSize)).values();
    }
}

