/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.backup.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.util.UrlEncoder;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.backup.model.BackupRestoreStatusResponse;
import java.util.ArrayList;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;

public class BackupRestoreStatusGetter
extends AsyncBaseClient<BackupRestoreStatusResponse>
implements AsyncClientResult<BackupRestoreStatusResponse> {
    private String backend;
    private String backupId;
    private String bucket;
    private String backupPath;

    public BackupRestoreStatusGetter(CloseableHttpAsyncClient client, Config config, AccessTokenProvider tokenProvider) {
        super(client, config, tokenProvider);
    }

    public BackupRestoreStatusGetter withBackend(String backend) {
        this.backend = backend;
        return this;
    }

    public BackupRestoreStatusGetter withBackupId(String backupId) {
        this.backupId = backupId;
        return this;
    }

    public BackupRestoreStatusGetter withBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public BackupRestoreStatusGetter withPath(String path) {
        this.backupPath = path;
        return this;
    }

    @Override
    public Future<Result<BackupRestoreStatusResponse>> run(FutureCallback<Result<BackupRestoreStatusResponse>> callback) {
        String path = String.format("/backups/%s/%s/restore", UrlEncoder.encodePathParam(this.backend), UrlEncoder.encodePathParam(this.backupId));
        ArrayList<String> queryParams = new ArrayList<String>();
        if (this.bucket != null) {
            queryParams.add(UrlEncoder.encodeQueryParam("bucket", this.bucket));
        }
        if (this.backupPath != null) {
            queryParams.add(UrlEncoder.encodeQueryParam("path", this.backupPath));
        }
        if (!queryParams.isEmpty()) {
            path = path + "?" + String.join((CharSequence)"&", queryParams);
        }
        return this.sendGetRequest(path, BackupRestoreStatusResponse.class, callback);
    }
}

