/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.base.util;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class CrossReference {
    private final String peerName;
    private final String className;
    private final String targetID;
    private final boolean local;

    public CrossReference(String peerName, String className, String targetID) {
        this.local = peerName != null && peerName.equals("localhost");
        this.peerName = peerName;
        this.className = className;
        this.targetID = targetID;
    }

    public static CrossReference fromBeacon(String beacon) {
        if (StringUtils.isNotBlank((CharSequence)beacon) && beacon.startsWith("weaviate://")) {
            String path = beacon.replaceFirst("weaviate://", "");
            String[] parts = path.split("/");
            if (parts.length == 3) {
                return new CrossReference(parts[0], parts[1], parts[2]);
            }
            if (parts.length == 2) {
                return new CrossReference(parts[0], "", parts[1]);
            }
        }
        return null;
    }

    @Generated
    public String toString() {
        return "CrossReference(peerName=" + this.getPeerName() + ", className=" + this.getClassName() + ", targetID=" + this.getTargetID() + ", local=" + this.isLocal() + ")";
    }

    @Generated
    public String getPeerName() {
        return this.peerName;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public String getTargetID() {
        return this.targetID;
    }

    @Generated
    public boolean isLocal() {
        return this.local;
    }
}

