/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.base;

import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.v1.graphql.model.GraphQLResponse;
import java.util.List;
import lombok.Generated;

public class Response<T> {
    private final int statusCode;
    private final T body;
    private final WeaviateErrorResponse errors;

    public Response(int statusCode, T body, WeaviateErrorResponse errors) {
        this.statusCode = statusCode;
        this.body = body;
        this.errors = body instanceof GraphQLResponse ? this.getWeaviateGraphQLErrorResponse((GraphQLResponse)body, statusCode) : errors;
    }

    private WeaviateErrorResponse getWeaviateGraphQLErrorResponse(GraphQLResponse gql, int code) {
        List<WeaviateErrorMessage> messages = gql.errorMessages();
        if (messages == null || messages.isEmpty()) {
            return null;
        }
        return WeaviateErrorResponse.builder().code(code).error(gql.errorMessages()).build();
    }

    @Generated
    public int getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public T getBody() {
        return this.body;
    }

    @Generated
    public WeaviateErrorResponse getErrors() {
        return this.errors;
    }
}

