/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import java.util.function.BiFunction;

public class UniOnItemOrFailureMap<I, O>
extends UniOperator<I, O> {
    private final BiFunction<? super I, Throwable, ? extends O> mapper;

    public UniOnItemOrFailureMap(Uni<I> source, BiFunction<? super I, Throwable, ? extends O> mapper) {
        super(ParameterValidation.nonNull(source, "source"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
    }

    @Override
    protected void subscribing(final UniSerializedSubscriber<? super O> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniDelegatingSubscriber<I, O>(subscriber){

            @Override
            public void onItem(I item) {
                if (!subscriber.isCancelledOrDone()) {
                    Object outcome;
                    try {
                        outcome = UniOnItemOrFailureMap.this.mapper.apply(item, null);
                    }
                    catch (Throwable e) {
                        subscriber.onFailure(e);
                        return;
                    }
                    subscriber.onItem(outcome);
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                if (!subscriber.isCancelledOrDone()) {
                    Object outcome;
                    try {
                        outcome = UniOnItemOrFailureMap.this.mapper.apply(null, failure);
                    }
                    catch (Throwable e) {
                        subscriber.onFailure(new CompositeException(failure, e));
                        return;
                    }
                    subscriber.onItem(outcome);
                }
            }
        });
    }
}

