/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.quarkus.mongodb.panache.PanacheQuery;
import io.quarkus.mongodb.panache.PanacheUpdate;
import io.quarkus.mongodb.panache.runtime.JavaMongoOperations;
import io.quarkus.mongodb.panache.runtime.MongoOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.common.impl.GenerateBridge;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.bson.Document;

public interface PanacheMongoRepositoryBase<Entity, Id> {
    public static final MongoOperations operations = new JavaMongoOperations();

    default public void persist(Entity entity) {
        operations.persist(entity);
    }

    default public void update(Entity entity) {
        operations.update(entity);
    }

    default public void persistOrUpdate(Entity entity) {
        operations.persistOrUpdate(entity);
    }

    default public void delete(Entity entity) {
        operations.delete(entity);
    }

    @GenerateBridge(targetReturnTypeErased=true)
    default public Entity findById(Id id) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Optional<Entity> findByIdOptional(Id id) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Object ... params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Object ... params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Map<String, Object> params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Map<String, Object> params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Parameters params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Parameters params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(Document query) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(Document query, Document sort) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> findAll() {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> findAll(Sort sort) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Object ... params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Sort sort, Object ... params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Map<String, Object> params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Sort sort, Map<String, Object> params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Parameters params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Sort sort, Parameters params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(Document query) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(Document query, Document sort) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> listAll() {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> listAll(Sort sort) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Object ... params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Sort sort, Object ... params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Map<String, Object> params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Sort sort, Map<String, Object> params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Parameters params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Sort sort, Parameters params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(Document query) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(Document query, Document sort) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> streamAll(Sort sort) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> streamAll() {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count() {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count(String query, Object ... params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count(String query, Map<String, Object> params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count(String query, Parameters params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count(Document query) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long deleteAll() {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public boolean deleteById(Id id) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long delete(String query, Object ... params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long delete(String query, Map<String, Object> params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long delete(String query, Parameters params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long delete(Document query) {
        throw operations.implementationInjectionMissing();
    }

    default public void persist(Iterable<Entity> entities) {
        operations.persist(entities);
    }

    default public void persist(Stream<Entity> entities) {
        operations.persist(entities);
    }

    default public void persist(Entity firstEntity, Entity ... entities) {
        operations.persist(firstEntity, (Object[])entities);
    }

    default public void update(Iterable<Entity> entities) {
        operations.update(entities);
    }

    default public void update(Stream<Entity> entities) {
        operations.update(entities);
    }

    default public void update(Entity firstEntity, Entity ... entities) {
        operations.update(firstEntity, (Object[])entities);
    }

    default public void persistOrUpdate(Iterable<Entity> entities) {
        operations.persistOrUpdate(entities);
    }

    default public void persistOrUpdate(Stream<Entity> entities) {
        operations.persistOrUpdate(entities);
    }

    default public void persistOrUpdate(Entity firstEntity, Entity ... entities) {
        operations.persistOrUpdate(firstEntity, (Object[])entities);
    }

    @GenerateBridge
    default public PanacheUpdate update(String update, Object ... params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheUpdate update(String update, Map<String, Object> params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheUpdate update(String update, Parameters params) {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public MongoCollection<Entity> mongoCollection() {
        throw operations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public MongoDatabase mongoDatabase() {
        throw operations.implementationInjectionMissing();
    }
}

