/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.contextpropagation;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;

public class ObservationThreadLocalAccessor
implements ThreadLocalAccessor<Observation> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(ObservationThreadLocalAccessor.class);
    public static final String KEY = "micrometer.observation";
    private static final ObservationRegistry observationRegistry = ObservationRegistry.create();
    private static final ThreadLocal<Observation.Scope> scopes = new ThreadLocal();

    public Object key() {
        return KEY;
    }

    public Observation getValue() {
        return observationRegistry.getCurrentObservation();
    }

    public void setValue(Observation value) {
        Observation.Scope scope = value.openScope();
        scopes.set(scope);
    }

    public void reset() {
        Observation.Scope scope = scopes.get();
        Observation.Scope scopeFromObservationRegistry = observationRegistry.getCurrentObservationScope();
        if (scopeFromObservationRegistry != scope) {
            LOG.warn("Scope from ObservationThreadLocalAccessor [" + scope + "] is not the same as the one from ObservationRegistry [" + scopeFromObservationRegistry + "]. You must have created additional scopes and forgotten to close them. Will close both of them");
            if (scopeFromObservationRegistry != null) {
                scopeFromObservationRegistry.close();
            }
        }
        if (scope != null) {
            scope.close();
            scopes.remove();
        }
    }
}

