/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1ListMeta;
import io.kubernetes.client.openapi.models.V1ListMetaBuilder;
import io.kubernetes.client.openapi.models.V1ListMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1RuntimeClass;
import io.kubernetes.client.openapi.models.V1RuntimeClassBuilder;
import io.kubernetes.client.openapi.models.V1RuntimeClassFluentImpl;
import io.kubernetes.client.openapi.models.V1RuntimeClassList;
import io.kubernetes.client.openapi.models.V1RuntimeClassListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class V1RuntimeClassListFluentImpl<A extends V1RuntimeClassListFluent<A>>
extends BaseFluent<A>
implements V1RuntimeClassListFluent<A> {
    private String apiVersion;
    private List<V1RuntimeClassBuilder> items;
    private String kind;
    private V1ListMetaBuilder metadata;

    public V1RuntimeClassListFluentImpl() {
    }

    public V1RuntimeClassListFluentImpl(V1RuntimeClassList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, V1RuntimeClass item) {
        if (this.items == null) {
            this.items = new ArrayList<V1RuntimeClassBuilder>();
        }
        V1RuntimeClassBuilder builder = new V1RuntimeClassBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, V1RuntimeClass item) {
        if (this.items == null) {
            this.items = new ArrayList<V1RuntimeClassBuilder>();
        }
        V1RuntimeClassBuilder builder = new V1RuntimeClassBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(V1RuntimeClass ... items) {
        if (this.items == null) {
            this.items = new ArrayList<V1RuntimeClassBuilder>();
        }
        for (V1RuntimeClass item : items) {
            V1RuntimeClassBuilder builder = new V1RuntimeClassBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<V1RuntimeClass> items) {
        if (this.items == null) {
            this.items = new ArrayList<V1RuntimeClassBuilder>();
        }
        for (V1RuntimeClass item : items) {
            V1RuntimeClassBuilder builder = new V1RuntimeClassBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(V1RuntimeClass ... items) {
        for (V1RuntimeClass item : items) {
            V1RuntimeClassBuilder builder = new V1RuntimeClassBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<V1RuntimeClass> items) {
        for (V1RuntimeClass item : items) {
            V1RuntimeClassBuilder builder = new V1RuntimeClassBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<V1RuntimeClassBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<V1RuntimeClassBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            V1RuntimeClassBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1RuntimeClass> getItems() {
        return V1RuntimeClassListFluentImpl.build(this.items);
    }

    @Override
    public List<V1RuntimeClass> buildItems() {
        return V1RuntimeClassListFluentImpl.build(this.items);
    }

    @Override
    public V1RuntimeClass buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public V1RuntimeClass buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public V1RuntimeClass buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public V1RuntimeClass buildMatchingItem(Predicate<V1RuntimeClassBuilder> predicate) {
        for (V1RuntimeClassBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<V1RuntimeClassBuilder> predicate) {
        for (V1RuntimeClassBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<V1RuntimeClass> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<V1RuntimeClassBuilder>();
            for (V1RuntimeClass item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(V1RuntimeClass ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (V1RuntimeClass item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public V1RuntimeClassListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public V1RuntimeClassListFluent.ItemsNested<A> addNewItemLike(V1RuntimeClass item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public V1RuntimeClassListFluent.ItemsNested<A> setNewItemLike(int index, V1RuntimeClass item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public V1RuntimeClassListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1RuntimeClassListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public V1RuntimeClassListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1RuntimeClassListFluent.ItemsNested<A> editMatchingItem(Predicate<V1RuntimeClassBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public V1ListMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ListMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ListMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1RuntimeClassListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1RuntimeClassListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1RuntimeClassListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1RuntimeClassListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ListMetaBuilder().build());
    }

    @Override
    public V1RuntimeClassListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1RuntimeClassListFluentImpl that = (V1RuntimeClassListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class MetadataNestedImpl<N>
    extends V1ListMetaFluentImpl<V1RuntimeClassListFluent.MetadataNested<N>>
    implements V1RuntimeClassListFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ListMetaBuilder builder;

        MetadataNestedImpl(V1ListMeta item) {
            this.builder = new V1ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1RuntimeClassListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends V1RuntimeClassFluentImpl<V1RuntimeClassListFluent.ItemsNested<N>>
    implements V1RuntimeClassListFluent.ItemsNested<N>,
    Nested<N> {
        private final V1RuntimeClassBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, V1RuntimeClass item) {
            this.index = index;
            this.builder = new V1RuntimeClassBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new V1RuntimeClassBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1RuntimeClassListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

