/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LrsLoadBalancer;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public final class LrsLoadBalancerProvider
extends LoadBalancerProvider {
    private static final String LRS_POLICY_NAME = "lrs_experimental";

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new LrsLoadBalancer(helper);
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return LRS_POLICY_NAME;
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        throw new UnsupportedOperationException();
    }

    static final class LrsConfig {
        final String clusterName;
        @Nullable
        final String edsServiceName;
        final String lrsServerName;
        final EnvoyProtoData.Locality locality;
        final ServiceConfigUtil.PolicySelection childPolicy;

        LrsConfig(String clusterName, @Nullable String edsServiceName, String lrsServerName, EnvoyProtoData.Locality locality, ServiceConfigUtil.PolicySelection childPolicy) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
            this.edsServiceName = edsServiceName;
            this.lrsServerName = (String)Preconditions.checkNotNull((Object)lrsServerName, (Object)"lrsServerName");
            this.locality = (EnvoyProtoData.Locality)Preconditions.checkNotNull((Object)locality, (Object)"locality");
            this.childPolicy = (ServiceConfigUtil.PolicySelection)Preconditions.checkNotNull((Object)childPolicy, (Object)"childPolicy");
        }
    }
}

