/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.xds.ClientLoadCounter;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.OrcaOobUtil;
import io.grpc.xds.OrcaPerRequestUtil;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.WeightedRandomPicker;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

interface LocalityStore {
    public void reset();

    public void updateLocalityStore(Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> var1);

    public void updateDropPercentage(List<EnvoyProtoData.DropOverload> var1);

    public void updateOobMetricsReportInterval(long var1);

    public static final class LocalityStoreImpl
    implements LocalityStore {
        private static final String ROUND_ROBIN = "round_robin";
        private static final long DELAYED_DELETION_TIMEOUT_MINUTES = 15L;
        private final XdsLogger logger;
        private final LoadBalancer.Helper helper;
        private final LoadBalancerProvider loadBalancerProvider;
        private final ThreadSafeRandom random;
        private final LoadStatsManager.LoadStatsStore loadStatsStore;
        private final OrcaPerRequestUtil orcaPerRequestUtil;
        private final OrcaOobUtil orcaOobUtil;
        private final PriorityManager priorityManager = new PriorityManager();
        private final Map<EnvoyProtoData.Locality, LocalityLbInfo> localityMap = new HashMap<EnvoyProtoData.Locality, LocalityLbInfo>();
        private List<EnvoyProtoData.DropOverload> dropOverloads = ImmutableList.of();
        private long metricsReportIntervalNano = -1L;

        LocalityStoreImpl(InternalLogId logId, LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry, LoadStatsManager.LoadStatsStore loadStatsStore) {
            this(logId, helper, lbRegistry, ThreadSafeRandom.ThreadSafeRandomImpl.instance, loadStatsStore, OrcaPerRequestUtil.getInstance(), OrcaOobUtil.getInstance());
        }

        @VisibleForTesting
        LocalityStoreImpl(InternalLogId logId, LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry, ThreadSafeRandom random, LoadStatsManager.LoadStatsStore loadStatsStore, OrcaPerRequestUtil orcaPerRequestUtil, OrcaOobUtil orcaOobUtil) {
            this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
            this.loadBalancerProvider = (LoadBalancerProvider)Preconditions.checkNotNull((Object)lbRegistry.getProvider(ROUND_ROBIN), (String)"Unable to find '%s' LoadBalancer", (Object)ROUND_ROBIN);
            this.random = (ThreadSafeRandom)Preconditions.checkNotNull((Object)random, (Object)"random");
            this.loadStatsStore = (LoadStatsManager.LoadStatsStore)Preconditions.checkNotNull((Object)loadStatsStore, (Object)"loadStatsStore");
            this.orcaPerRequestUtil = (OrcaPerRequestUtil)Preconditions.checkNotNull((Object)orcaPerRequestUtil, (Object)"orcaPerRequestUtil");
            this.orcaOobUtil = (OrcaOobUtil)Preconditions.checkNotNull((Object)orcaOobUtil, (Object)"orcaOobUtil");
            this.logger = XdsLogger.withLogId((InternalLogId)Preconditions.checkNotNull((Object)logId, (Object)"logId"));
        }

        @Override
        public void reset() {
            for (EnvoyProtoData.Locality locality : this.localityMap.keySet()) {
                this.localityMap.get(locality).shutdown();
            }
            this.localityMap.clear();
            this.priorityManager.reset();
        }

        @Override
        public void updateLocalityStore(Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityInfoMap) {
            Set<EnvoyProtoData.Locality> newLocalities = localityInfoMap.keySet();
            for (EnvoyProtoData.Locality locality : newLocalities) {
                if (!this.localityMap.containsKey(locality)) continue;
                LocalityLbInfo localityLbInfo = this.localityMap.get(locality);
                localityLbInfo.refreshEndpoints(localityInfoMap.get(locality));
            }
            this.priorityManager.updateLocalities(localityInfoMap);
            for (EnvoyProtoData.Locality oldLocality : this.localityMap.keySet()) {
                if (newLocalities.contains(oldLocality)) continue;
                this.deactivate(oldLocality);
            }
        }

        @Override
        public void updateDropPercentage(List<EnvoyProtoData.DropOverload> dropOverloads) {
            this.dropOverloads = (List)Preconditions.checkNotNull(dropOverloads, (Object)"dropOverloads");
        }

        private void deactivate(final EnvoyProtoData.Locality locality) {
            if (!this.localityMap.containsKey(locality) || this.localityMap.get(locality).isDeactivated()) {
                return;
            }
            final LocalityLbInfo localityLbInfo = this.localityMap.get(locality);
            class DeletionTask
            implements Runnable {
                DeletionTask() {
                }

                @Override
                public void run() {
                    localityLbInfo.shutdown();
                    LocalityStoreImpl.this.localityMap.remove(locality);
                }

                public String toString() {
                    return "DeletionTask: locality=" + locality;
                }
            }
            localityLbInfo.delayedDeletionTimer = this.helper.getSynchronizationContext().schedule((Runnable)new DeletionTask(), 15L, TimeUnit.MINUTES, this.helper.getScheduledExecutorService());
        }

        @Override
        public void updateOobMetricsReportInterval(long reportIntervalNano) {
            this.metricsReportIntervalNano = reportIntervalNano;
            for (LocalityLbInfo lbInfo : this.localityMap.values()) {
                lbInfo.childHelper.updateMetricsReportInterval(reportIntervalNano);
            }
        }

        @Nullable
        private static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
            if (overallState == null) {
                return childState;
            }
            if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
                return ConnectivityState.READY;
            }
            if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
                return ConnectivityState.CONNECTING;
            }
            if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
                return ConnectivityState.IDLE;
            }
            return overallState;
        }

        private void updatePicker(@Nullable ConnectivityState state, List<WeightedRandomPicker.WeightedChildPicker> childPickers) {
            LoadBalancer.SubchannelPicker picker = childPickers.isEmpty() ? (state == ConnectivityState.TRANSIENT_FAILURE ? new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE) : XdsSubchannelPickers.BUFFER_PICKER) : new WeightedRandomPicker(childPickers);
            if (!this.dropOverloads.isEmpty()) {
                picker = new DroppablePicker(this.dropOverloads, picker, this.random, this.loadStatsStore);
            }
            if (state != null) {
                this.helper.updateBalancingState(state, picker);
            }
        }

        private final class PriorityManager {
            private final List<List<EnvoyProtoData.Locality>> priorityTable = new ArrayList<List<EnvoyProtoData.Locality>>();
            private Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityInfoMap = ImmutableMap.of();
            private int currentPriority = -1;
            private SynchronizationContext.ScheduledHandle failOverTimer;

            private PriorityManager() {
            }

            void updateLocalities(Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityInfoMap) {
                this.localityInfoMap = localityInfoMap;
                this.priorityTable.clear();
                for (EnvoyProtoData.Locality newLocality : localityInfoMap.keySet()) {
                    int priority = localityInfoMap.get(newLocality).getPriority();
                    while (this.priorityTable.size() <= priority) {
                        this.priorityTable.add(new ArrayList());
                    }
                    this.priorityTable.get(priority).add(newLocality);
                }
                if (LocalityStoreImpl.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                    for (int i = 0; i < this.priorityTable.size(); ++i) {
                        LocalityStoreImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Priority {0} contains localities: {1}", i, this.priorityTable.get(i));
                    }
                }
                if (this.priorityTable.isEmpty()) {
                    LocalityStoreImpl.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("Received 0 locality")));
                    return;
                }
                this.currentPriority = -1;
                this.failOver();
            }

            void updatePriorityState(int priority) {
                if (priority == -1 || priority > this.currentPriority) {
                    return;
                }
                ArrayList<WeightedRandomPicker.WeightedChildPicker> childPickers = new ArrayList<WeightedRandomPicker.WeightedChildPicker>();
                ConnectivityState overallState = null;
                for (EnvoyProtoData.Locality l : this.priorityTable.get(priority)) {
                    if (!LocalityStoreImpl.this.localityMap.containsKey(l)) {
                        this.initLocality(l);
                    }
                    LocalityLbInfo localityLbInfo = (LocalityLbInfo)LocalityStoreImpl.this.localityMap.get(l);
                    localityLbInfo.reactivate();
                    ConnectivityState childState = localityLbInfo.childHelper.currentChildState;
                    LoadBalancer.SubchannelPicker childPicker = localityLbInfo.childHelper.currentChildPicker;
                    overallState = LocalityStoreImpl.aggregateState(overallState, childState);
                    if (ConnectivityState.READY != childState) continue;
                    childPickers.add(new WeightedRandomPicker.WeightedChildPicker(this.localityInfoMap.get(l).getLocalityWeight(), childPicker));
                }
                LocalityStoreImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Update priority {0} state to {1}", priority, overallState);
                if (priority == this.currentPriority) {
                    LocalityStoreImpl.this.updatePicker(overallState, childPickers);
                    if (overallState == ConnectivityState.READY) {
                        this.cancelFailOverTimer();
                    } else if (overallState == ConnectivityState.TRANSIENT_FAILURE) {
                        this.cancelFailOverTimer();
                        this.failOver();
                    } else if (this.failOverTimer == null) {
                        this.failOver();
                    }
                } else if (overallState == ConnectivityState.READY) {
                    LocalityStoreImpl.this.updatePicker(overallState, childPickers);
                    this.cancelFailOverTimer();
                    this.currentPriority = priority;
                }
                if (overallState == ConnectivityState.READY) {
                    for (int p = priority + 1; p < this.priorityTable.size(); ++p) {
                        for (EnvoyProtoData.Locality xdsLocality : this.priorityTable.get(p)) {
                            LocalityStoreImpl.this.deactivate(xdsLocality);
                        }
                    }
                }
            }

            int getPriority(EnvoyProtoData.Locality locality) {
                if (this.localityInfoMap.containsKey(locality)) {
                    return this.localityInfoMap.get(locality).getPriority();
                }
                return -1;
            }

            void reset() {
                this.cancelFailOverTimer();
                this.priorityTable.clear();
                this.localityInfoMap = ImmutableMap.of();
                this.currentPriority = -1;
            }

            private void cancelFailOverTimer() {
                if (this.failOverTimer != null) {
                    this.failOverTimer.cancel();
                    this.failOverTimer = null;
                }
            }

            private void failOver() {
                if (this.currentPriority == this.priorityTable.size() - 1) {
                    return;
                }
                ++this.currentPriority;
                List<EnvoyProtoData.Locality> localities = this.priorityTable.get(this.currentPriority);
                boolean initializedBefore = false;
                for (EnvoyProtoData.Locality locality : localities) {
                    if (LocalityStoreImpl.this.localityMap.containsKey(locality)) {
                        initializedBefore = true;
                        ((LocalityLbInfo)LocalityStoreImpl.this.localityMap.get(locality)).reactivate();
                        continue;
                    }
                    this.initLocality(locality);
                }
                if (!initializedBefore) {
                    class FailOverTask
                    implements Runnable {
                        FailOverTask() {
                        }

                        @Override
                        public void run() {
                            LocalityStoreImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Failing over to priority {0}", PriorityManager.this.currentPriority + 1);
                            PriorityManager.this.failOverTimer = null;
                            PriorityManager.this.failOver();
                        }
                    }
                    this.failOverTimer = LocalityStoreImpl.this.helper.getSynchronizationContext().schedule((Runnable)new FailOverTask(), 10L, TimeUnit.SECONDS, LocalityStoreImpl.this.helper.getScheduledExecutorService());
                }
                this.updatePriorityState(this.currentPriority);
            }

            private void initLocality(EnvoyProtoData.Locality locality) {
                LocalityStoreImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Create child balancer for locality {0}", locality);
                LocalityLbInfo localityLbInfo = new LocalityLbInfo(locality);
                LocalityStoreImpl.this.localityMap.put(locality, localityLbInfo);
                localityLbInfo.refreshEndpoints(this.localityInfoMap.get(locality));
            }
        }

        private final class LocalityLbInfo {
            final EnvoyProtoData.Locality locality;
            final LoadBalancer childBalancer;
            final ChildHelper childHelper;
            @Nullable
            private SynchronizationContext.ScheduledHandle delayedDeletionTimer;

            LocalityLbInfo(EnvoyProtoData.Locality locality) {
                this.locality = (EnvoyProtoData.Locality)Preconditions.checkNotNull((Object)locality, (Object)"locality");
                ClientLoadCounter counter = LocalityStoreImpl.this.loadStatsStore.addLocality(locality);
                this.childHelper = new ChildHelper(counter);
                this.childBalancer = LocalityStoreImpl.this.loadBalancerProvider.newLoadBalancer((LoadBalancer.Helper)this.childHelper);
            }

            void refreshEndpoints(EnvoyProtoData.LocalityLbEndpoints localityLbEndpoints) {
                final ArrayList<EquivalentAddressGroup> eags = new ArrayList<EquivalentAddressGroup>();
                for (EnvoyProtoData.LbEndpoint endpoint : localityLbEndpoints.getEndpoints()) {
                    if (!endpoint.isHealthy()) continue;
                    eags.add(endpoint.getAddress());
                }
                this.childHelper.getSynchronizationContext().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (eags.isEmpty() && !LocalityLbInfo.this.childBalancer.canHandleEmptyAddressListFromNameResolution()) {
                            LocalityLbInfo.this.childBalancer.handleNameResolutionError(Status.UNAVAILABLE.withDescription("Locality " + LocalityLbInfo.this.locality + " has no healthy endpoint"));
                        } else {
                            LocalityLbInfo.this.childBalancer.handleResolvedAddresses(LoadBalancer.ResolvedAddresses.newBuilder().setAddresses(eags).build());
                        }
                    }
                });
            }

            void shutdown() {
                if (this.delayedDeletionTimer != null) {
                    this.delayedDeletionTimer.cancel();
                    this.delayedDeletionTimer = null;
                }
                this.childBalancer.shutdown();
                LocalityStoreImpl.this.loadStatsStore.removeLocality(this.locality);
                LocalityStoreImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shut down child balancer for locality {0}", this.locality);
            }

            void reactivate() {
                if (this.delayedDeletionTimer != null) {
                    this.delayedDeletionTimer.cancel();
                    this.delayedDeletionTimer = null;
                }
            }

            boolean isDeactivated() {
                return this.delayedDeletionTimer != null;
            }

            class ChildHelper
            extends ForwardingLoadBalancerHelper {
                private final OrcaOobUtil.OrcaReportingHelperWrapper orcaReportingHelperWrapper;
                private LoadBalancer.SubchannelPicker currentChildPicker = XdsSubchannelPickers.BUFFER_PICKER;
                private ConnectivityState currentChildState = ConnectivityState.CONNECTING;

                ChildHelper(final ClientLoadCounter counter) {
                    ForwardingLoadBalancerHelper delegate = new ForwardingLoadBalancerHelper(){

                        protected LoadBalancer.Helper delegate() {
                            return LocalityStoreImpl.this.helper;
                        }

                        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                            LocalityStoreImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Update load balancing state for locality {0} to {1}", LocalityLbInfo.this.locality, newState);
                            ChildHelper.this.currentChildState = newState;
                            ChildHelper.this.currentChildPicker = new ClientLoadCounter.LoadRecordingSubchannelPicker(counter, new ClientLoadCounter.MetricsObservingSubchannelPicker(new ClientLoadCounter.MetricsRecordingListener(counter), newPicker, LocalityStoreImpl.this.orcaPerRequestUtil));
                            LocalityStoreImpl.this.priorityManager.updatePriorityState(LocalityStoreImpl.this.priorityManager.getPriority(LocalityLbInfo.this.locality));
                        }

                        public String getAuthority() {
                            return LocalityLbInfo.this.locality.getSubZone();
                        }
                    };
                    this.orcaReportingHelperWrapper = LocalityStoreImpl.this.orcaOobUtil.newOrcaReportingHelperWrapper((LoadBalancer.Helper)delegate, new ClientLoadCounter.MetricsRecordingListener(counter));
                    if (LocalityStoreImpl.this.metricsReportIntervalNano > 0L) {
                        this.updateMetricsReportInterval(LocalityStoreImpl.this.metricsReportIntervalNano);
                    }
                }

                void updateMetricsReportInterval(long intervalNanos) {
                    this.orcaReportingHelperWrapper.setReportingConfig(OrcaOobUtil.OrcaReportingConfig.newBuilder().setReportInterval(intervalNanos, TimeUnit.NANOSECONDS).build());
                }

                protected LoadBalancer.Helper delegate() {
                    return this.orcaReportingHelperWrapper.asHelper();
                }
            }
        }

        private final class DroppablePicker
        extends LoadBalancer.SubchannelPicker {
            final List<EnvoyProtoData.DropOverload> dropOverloads;
            final LoadBalancer.SubchannelPicker delegate;
            final ThreadSafeRandom random;
            final LoadStatsManager.LoadStatsStore loadStatsStore;

            DroppablePicker(List<EnvoyProtoData.DropOverload> dropOverloads, LoadBalancer.SubchannelPicker delegate, ThreadSafeRandom random, LoadStatsManager.LoadStatsStore loadStatsStore) {
                this.dropOverloads = dropOverloads;
                this.delegate = delegate;
                this.random = random;
                this.loadStatsStore = loadStatsStore;
            }

            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                for (EnvoyProtoData.DropOverload dropOverload : this.dropOverloads) {
                    int rand = this.random.nextInt(1000000);
                    if (rand >= dropOverload.getDropsPerMillion()) continue;
                    LocalityStoreImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Drop request with category: {0}", dropOverload.getCategory());
                    this.loadStatsStore.recordDroppedRequest(dropOverload.getCategory());
                    return LoadBalancer.PickResult.withDrop((Status)Status.UNAVAILABLE.withDescription("dropped by loadbalancer: " + dropOverload.toString()));
                }
                return this.delegate.pickSubchannel(args);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)((Object)this)).add("dropOverloads", this.dropOverloads).add("delegate", (Object)this.delegate).toString();
            }
        }
    }

    @VisibleForTesting
    public static abstract class LocalityStoreFactory {
        private static final LocalityStoreFactory DEFAULT_INSTANCE = new LocalityStoreFactory(){

            @Override
            LocalityStore newLocalityStore(InternalLogId logId, LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry, LoadStatsManager.LoadStatsStore loadStatsStore) {
                return new LocalityStoreImpl(logId, helper, lbRegistry, loadStatsStore);
            }
        };

        static LocalityStoreFactory getInstance() {
            return DEFAULT_INSTANCE;
        }

        abstract LocalityStore newLocalityStore(InternalLogId var1, LoadBalancer.Helper var2, LoadBalancerRegistry var3, LoadStatsManager.LoadStatsStore var4);
    }
}

