/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import java.util.Optional;

public enum ResourceTypeFlagEnum {
    DRIVER((byte)0, "driver", "\u9a71\u52a8"),
    PROFILE((byte)1, "profile", "\u6a21\u7248"),
    POINT((byte)2, "point", "\u4f4d\u53f7"),
    DEVICE((byte)3, "device", "\u8bbe\u5907"),
    DATA((byte)4, "data", "\u6570\u636e"),
    MENU((byte)5, "menu", "\u83dc\u5355"),
    API((byte)6, "api", "\u63a5\u53e3");

    @EnumValue
    private final Byte index;
    private final String code;
    private final String text;

    public static ResourceTypeFlagEnum ofIndex(Byte index) {
        Optional<ResourceTypeFlagEnum> any = Arrays.stream(ResourceTypeFlagEnum.values()).filter(type -> type.getIndex().equals(index)).findFirst();
        return any.orElse(null);
    }

    public static ResourceTypeFlagEnum ofCode(String code) {
        Optional<ResourceTypeFlagEnum> any = Arrays.stream(ResourceTypeFlagEnum.values()).filter(type -> type.getCode().equals(code)).findFirst();
        return any.orElse(null);
    }

    public static ResourceTypeFlagEnum ofName(String name) {
        try {
            return ResourceTypeFlagEnum.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Byte getIndex() {
        return this.index;
    }

    public String getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    private ResourceTypeFlagEnum(Byte index, String code, String text) {
        this.index = index;
        this.code = code;
        this.text = text;
    }
}

