/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import java.util.Optional;

public enum ExpireFlagEnum {
    PERMANENT((byte)0, "permanent", "\u6c38\u4e45"),
    ONE_DAY((byte)1, "one_day", "\u4e00\u5929"),
    ONE_WEEK((byte)2, "one_week", "\u4e00\u5468"),
    ONE_MONTH((byte)3, "one_month", "\u4e00\u6708"),
    THREE_MONTHS((byte)4, "three_months", "\u4e09\u6708"),
    HALF_YEAR((byte)5, "half_year", "\u534a\u5e74"),
    ONE_YEAR((byte)6, "one_year", "\u4e00\u5e74"),
    CUSTOM((byte)7, "custom", "\u81ea\u5b9a\u4e49");

    @EnumValue
    private final Byte index;
    private final String code;
    private final String remark;

    public static ExpireFlagEnum ofIndex(Byte index) {
        Optional<ExpireFlagEnum> any = Arrays.stream(ExpireFlagEnum.values()).filter(type -> type.getIndex().equals(index)).findFirst();
        return any.orElse(null);
    }

    public static ExpireFlagEnum ofCode(String code) {
        Optional<ExpireFlagEnum> any = Arrays.stream(ExpireFlagEnum.values()).filter(type -> type.getCode().equals(code)).findFirst();
        return any.orElse(null);
    }

    public static ExpireFlagEnum ofName(String name) {
        try {
            return ExpireFlagEnum.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Byte getIndex() {
        return this.index;
    }

    public String getCode() {
        return this.code;
    }

    public String getRemark() {
        return this.remark;
    }

    private ExpireFlagEnum(Byte index, String code, String remark) {
        this.index = index;
        this.code = code;
        this.remark = remark;
    }
}

