/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import java.util.Optional;

public enum AutoConfirmFlagEnum {
    AUTO((byte)0, "auto", "AUTO"),
    MANUAL((byte)1, "manual", "\u624b\u52a8");

    @EnumValue
    private final Byte index;
    private final String code;
    private final String remark;

    public static AutoConfirmFlagEnum ofIndex(Byte index) {
        Optional<AutoConfirmFlagEnum> any = Arrays.stream(AutoConfirmFlagEnum.values()).filter(type -> type.getIndex().equals(index)).findFirst();
        return any.orElse(null);
    }

    public static AutoConfirmFlagEnum ofCode(String code) {
        Optional<AutoConfirmFlagEnum> any = Arrays.stream(AutoConfirmFlagEnum.values()).filter(type -> type.getCode().equals(code)).findFirst();
        return any.orElse(null);
    }

    public static AutoConfirmFlagEnum ofName(String name) {
        try {
            return AutoConfirmFlagEnum.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Byte getIndex() {
        return this.index;
    }

    public String getCode() {
        return this.code;
    }

    public String getRemark() {
        return this.remark;
    }

    private AutoConfirmFlagEnum(Byte index, String code, String remark) {
        this.index = index;
        this.code = code;
        this.remark = remark;
    }
}

