/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import java.util.Optional;

public enum AttributeTypeFlagEnum {
    STRING((byte)0, "string", "\u5b57\u7b26\u4e32"),
    BYTE((byte)1, "byte", "\u5b57\u8282"),
    SHORT((byte)2, "short", "\u77ed\u6574\u6570"),
    INT((byte)3, "int", "\u6574\u6570"),
    LONG((byte)4, "long", "\u957f\u6574\u6570"),
    FLOAT((byte)5, "float", "\u6d6e\u70b9\u6570"),
    DOUBLE((byte)6, "double", "\u53cc\u7cbe\u5ea6\u6d6e\u70b9\u6570"),
    BOOLEAN((byte)7, "boolean", "\u5e03\u5c14\u91cf");

    @EnumValue
    private final Byte index;
    private final String code;
    private final String remark;

    public static AttributeTypeFlagEnum ofIndex(Byte index) {
        Optional<AttributeTypeFlagEnum> any = Arrays.stream(AttributeTypeFlagEnum.values()).filter(type -> type.getIndex().equals(index)).findFirst();
        return any.orElse(null);
    }

    public static AttributeTypeFlagEnum ofCode(String code) {
        Optional<AttributeTypeFlagEnum> any = Arrays.stream(AttributeTypeFlagEnum.values()).filter(type -> type.getCode().equals(code)).findFirst();
        return any.orElse(null);
    }

    public static AttributeTypeFlagEnum ofName(String name) {
        try {
            return AttributeTypeFlagEnum.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Byte getIndex() {
        return this.index;
    }

    public String getCode() {
        return this.code;
    }

    public String getRemark() {
        return this.remark;
    }

    private AttributeTypeFlagEnum(Byte index, String code, String remark) {
        this.index = index;
        this.code = code;
        this.remark = remark;
    }
}

