/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.starter.support.aop;

import com.mzt.logapi.beans.LogRecordOps;
import com.mzt.logapi.starter.annotation.LogRecord;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class LogRecordOperationSource {
    public Collection<LogRecordOps> computeLogRecordOperations(Method method, Class<?> targetClass) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
        return this.parseLogRecordAnnotations(specificMethod);
    }

    private Collection<LogRecordOps> parseLogRecordAnnotations(AnnotatedElement ae) {
        Set logRecordAnnotationAnnotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)ae, LogRecord.class);
        Collection<LogRecordOps> ret = null;
        if (!logRecordAnnotationAnnotations.isEmpty()) {
            ret = this.lazyInit(ret);
            for (LogRecord recordAnnotation : logRecordAnnotationAnnotations) {
                ret.add(this.parseLogRecordAnnotation(ae, recordAnnotation));
            }
        }
        return ret;
    }

    private LogRecordOps parseLogRecordAnnotation(AnnotatedElement ae, LogRecord recordAnnotation) {
        LogRecordOps recordOps = LogRecordOps.builder().successLogTemplate(recordAnnotation.success()).failLogTemplate(recordAnnotation.fail()).type(recordAnnotation.type()).bizNo(recordAnnotation.bizNo()).operatorId(recordAnnotation.operator()).subType(recordAnnotation.subType()).extra(recordAnnotation.extra()).condition(recordAnnotation.condition()).build();
        this.validateLogRecordOperation(ae, recordOps);
        return recordOps;
    }

    private void validateLogRecordOperation(AnnotatedElement ae, LogRecordOps recordOps) {
        if (!StringUtils.hasText((String)recordOps.getSuccessLogTemplate()) && !StringUtils.hasText((String)recordOps.getFailLogTemplate())) {
            throw new IllegalStateException("Invalid logRecord annotation configuration on '" + ae.toString() + "'. 'one of successTemplate and failLogTemplate' attribute must be set.");
        }
    }

    private Collection<LogRecordOps> lazyInit(Collection<LogRecordOps> ops) {
        return ops != null ? ops : new ArrayList(1);
    }
}

