/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.starter.support.aop;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mzt.logapi.beans.LogRecord;
import com.mzt.logapi.beans.LogRecordOps;
import com.mzt.logapi.context.LogRecordContext;
import com.mzt.logapi.service.ILogRecordService;
import com.mzt.logapi.service.IOperatorGetService;
import com.mzt.logapi.starter.support.aop.LogRecordOperationSource;
import com.mzt.logapi.starter.support.parse.LogRecordValueParser;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class LogRecordInterceptor
extends LogRecordValueParser
implements InitializingBean,
MethodInterceptor,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(LogRecordInterceptor.class);
    private LogRecordOperationSource logRecordOperationSource;
    private String tenantId;
    private ILogRecordService bizLogService;
    private IOperatorGetService operatorGetService;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        return this.execute(invocation, invocation.getThis(), method, invocation.getArguments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute(MethodInvocation invoker, Object target, Method method, Object[] args) throws Throwable {
        Class<?> targetClass = this.getTargetClass(target);
        Object ret = null;
        MethodExecuteResult methodExecuteResult = new MethodExecuteResult(true, null, "");
        LogRecordContext.putEmptySpan();
        ArrayList<LogRecordOps> operations = new ArrayList();
        HashMap<String, String> functionNameAndReturnMap = new HashMap();
        try {
            operations = this.logRecordOperationSource.computeLogRecordOperations(method, targetClass);
            List<String> spElTemplates = this.getBeforeExecuteFunctionTemplate(operations);
            functionNameAndReturnMap = this.processBeforeExecuteFunctionTemplate(spElTemplates, targetClass, method, args);
        }
        catch (Exception e) {
            log.error("log record parse before function exception", (Throwable)e);
        }
        try {
            ret = invoker.proceed();
        }
        catch (Exception e) {
            methodExecuteResult = new MethodExecuteResult(false, e, e.getMessage());
        }
        try {
            if (!CollectionUtils.isEmpty(operations)) {
                this.recordExecute(ret, method, args, operations, targetClass, methodExecuteResult.isSuccess(), methodExecuteResult.getErrorMsg(), functionNameAndReturnMap);
            }
        }
        catch (Exception t) {
            log.error("log record parse exception", (Throwable)t);
        }
        finally {
            LogRecordContext.clear();
        }
        if (methodExecuteResult.throwable != null) {
            throw methodExecuteResult.throwable;
        }
        return ret;
    }

    private List<String> getBeforeExecuteFunctionTemplate(Collection<LogRecordOps> operations) {
        ArrayList<String> spElTemplates = new ArrayList<String>();
        for (LogRecordOps operation : operations) {
            List<String> templates = this.getSpElTemplates(operation, operation.getSuccessLogTemplate());
            if (CollectionUtils.isEmpty(templates)) continue;
            spElTemplates.addAll(templates);
        }
        return spElTemplates;
    }

    private void recordExecute(Object ret, Method method, Object[] args, Collection<LogRecordOps> operations, Class<?> targetClass, boolean success, String errorMsg, Map<String, String> functionNameAndReturnMap) {
        for (LogRecordOps operation : operations) {
            try {
                LogRecord logRecord;
                String action = this.getActionContent(success, operation);
                if (StringUtils.isEmpty((Object)action)) continue;
                List<String> spElTemplates = this.getSpElTemplates(operation, action);
                String operatorIdFromService = this.getOperatorIdFromServiceAndPutTemplate(operation, spElTemplates);
                Map<String, String> expressionValues = this.processTemplate(spElTemplates, ret, targetClass, method, args, errorMsg, functionNameAndReturnMap);
                if (!this.logConditionPassed(operation.getCondition(), expressionValues) || StringUtils.isEmpty((Object)(logRecord = LogRecord.builder().tenant(this.tenantId).type(expressionValues.get(operation.getType())).bizNo(expressionValues.get(operation.getBizNo())).operator(this.getRealOperatorId(operation, operatorIdFromService, expressionValues)).subType(operation.getSubType()).extra(expressionValues.get(operation.getExtra())).action(expressionValues.get(action)).fail(!success).createTime(new Date()).build()).getAction())) continue;
                Preconditions.checkNotNull((Object)this.bizLogService, (Object)"bizLogService not init!!");
                this.bizLogService.record(logRecord);
            }
            catch (Exception t) {
                log.error("log record execute exception", (Throwable)t);
            }
        }
    }

    private List<String> getSpElTemplates(LogRecordOps operation, String action) {
        ArrayList spElTemplates = Lists.newArrayList((Object[])new String[]{operation.getType(), operation.getBizNo(), action, operation.getExtra()});
        if (!StringUtils.isEmpty((Object)operation.getCondition())) {
            spElTemplates.add(operation.getCondition());
        }
        return spElTemplates;
    }

    private boolean logConditionPassed(String condition, Map<String, String> expressionValues) {
        return StringUtils.isEmpty((Object)condition) || StringUtils.endsWithIgnoreCase((String)expressionValues.get(condition), (String)"true");
    }

    private String getRealOperatorId(LogRecordOps operation, String operatorIdFromService, Map<String, String> expressionValues) {
        return !StringUtils.isEmpty((Object)operatorIdFromService) ? operatorIdFromService : expressionValues.get(operation.getOperatorId());
    }

    private String getOperatorIdFromServiceAndPutTemplate(LogRecordOps operation, List<String> spElTemplates) {
        String realOperatorId = "";
        if (StringUtils.isEmpty((Object)operation.getOperatorId())) {
            realOperatorId = this.operatorGetService.getUser().getOperatorId();
            if (StringUtils.isEmpty((Object)realOperatorId)) {
                throw new IllegalArgumentException("[LogRecord] operator is null");
            }
        } else {
            spElTemplates.add(operation.getOperatorId());
        }
        return realOperatorId;
    }

    private String getActionContent(boolean success, LogRecordOps operation) {
        String action = "";
        action = success ? operation.getSuccessLogTemplate() : operation.getFailLogTemplate();
        return action;
    }

    private Class<?> getTargetClass(Object target) {
        return AopProxyUtils.ultimateTargetClass((Object)target);
    }

    public void setLogRecordOperationSource(LogRecordOperationSource logRecordOperationSource) {
        this.logRecordOperationSource = logRecordOperationSource;
    }

    public void setTenant(String tenant) {
        this.tenantId = tenant;
    }

    public void setLogRecordService(ILogRecordService bizLogService) {
        this.bizLogService = bizLogService;
    }

    public void afterPropertiesSet() throws Exception {
        this.bizLogService = (ILogRecordService)this.beanFactory.getBean(ILogRecordService.class);
        this.operatorGetService = (IOperatorGetService)this.beanFactory.getBean(IOperatorGetService.class);
        Preconditions.checkNotNull((Object)this.bizLogService, (Object)"bizLogService not null");
    }

    public void setOperatorGetService(IOperatorGetService operatorGetService) {
        this.operatorGetService = operatorGetService;
    }

    static class MethodExecuteResult {
        private boolean success;
        private Throwable throwable;
        private String errorMsg;

        public boolean isSuccess() {
            return this.success;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodExecuteResult)) {
                return false;
            }
            MethodExecuteResult other = (MethodExecuteResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            Throwable this$throwable = this.getThrowable();
            Throwable other$throwable = other.getThrowable();
            if (this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable)) {
                return false;
            }
            String this$errorMsg = this.getErrorMsg();
            String other$errorMsg = other.getErrorMsg();
            return !(this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodExecuteResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            Throwable $throwable = this.getThrowable();
            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
            String $errorMsg = this.getErrorMsg();
            result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
            return result;
        }

        public String toString() {
            return "LogRecordInterceptor.MethodExecuteResult(success=" + this.isSuccess() + ", throwable=" + this.getThrowable() + ", errorMsg=" + this.getErrorMsg() + ")";
        }

        public MethodExecuteResult(boolean success, Throwable throwable, String errorMsg) {
            this.success = success;
            this.throwable = throwable;
            this.errorMsg = errorMsg;
        }

        public MethodExecuteResult() {
        }
    }
}

