/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.starter.diff;

import com.google.common.collect.Lists;
import com.mzt.logapi.service.IFunctionService;
import com.mzt.logapi.starter.annotation.DiffLogField;
import com.mzt.logapi.starter.configuration.LogRecordProperties;
import com.mzt.logapi.starter.diff.IDiffItemsToLogContentService;
import de.danielbechler.diff.node.DiffNode;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultDiffItemsToLogContentService
implements IDiffItemsToLogContentService {
    private static final Logger log = LoggerFactory.getLogger(DefaultDiffItemsToLogContentService.class);
    private final IFunctionService functionService;
    private final LogRecordProperties logRecordProperties;

    @Override
    public String toLogContent(DiffNode diffNode, Object sourceObject, Object targetObject) {
        if (!diffNode.hasChanges()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        diffNode.visit((node, visit) -> this.generateAllFieldLog(sourceObject, targetObject, stringBuilder, node));
        return stringBuilder.toString().replaceAll(this.logRecordProperties.getFieldSeparator().concat("$"), "");
    }

    private void generateAllFieldLog(Object sourceObject, Object targetObject, StringBuilder stringBuilder, DiffNode node) {
        if (node.isRootNode()) {
            return;
        }
        DiffLogField diffLogFieldAnnotation = (DiffLogField)node.getFieldAnnotation(DiffLogField.class);
        if (diffLogFieldAnnotation == null || node.getValueTypeInfo() != null) {
            return;
        }
        String filedLogName = this.getFieldLogName(node, diffLogFieldAnnotation);
        if (StringUtils.isEmpty((Object)filedLogName)) {
            return;
        }
        boolean valueIsCollection = this.valueIsCollection(node, sourceObject, targetObject);
        DiffNode.State state = node.getState();
        String logContent = this.getDiffLogContent(filedLogName, node, state, sourceObject, targetObject, diffLogFieldAnnotation.function(), valueIsCollection);
        if (!StringUtils.isEmpty((Object)logContent)) {
            stringBuilder.append(logContent).append(this.logRecordProperties.getFieldSeparator());
        }
    }

    private String getFieldLogName(DiffNode node, DiffLogField diffLogFieldAnnotation) {
        String filedLogName = diffLogFieldAnnotation.name();
        if (node.getParentNode() != null) {
            filedLogName = this.getParentFieldName(node) + filedLogName;
        }
        return filedLogName;
    }

    private boolean valueIsCollection(DiffNode node, Object sourceObject, Object targetObject) {
        if (sourceObject != null) {
            Object sourceValue = node.canonicalGet(sourceObject);
            if (sourceValue == null && targetObject != null) {
                return node.canonicalGet(targetObject) instanceof Collection;
            }
            return sourceValue instanceof Collection;
        }
        return false;
    }

    private String getParentFieldName(DiffNode node) {
        DiffNode parent = node.getParentNode();
        String fieldNamePrefix = "";
        while (parent != null) {
            DiffLogField diffLogFieldAnnotation = (DiffLogField)parent.getFieldAnnotation(DiffLogField.class);
            if (diffLogFieldAnnotation == null) {
                parent = parent.getParentNode();
                continue;
            }
            fieldNamePrefix = diffLogFieldAnnotation.name().concat(this.logRecordProperties.getOfWord()).concat(fieldNamePrefix);
            parent = parent.getParentNode();
        }
        return fieldNamePrefix;
    }

    public String getDiffLogContent(String filedLogName, DiffNode node, DiffNode.State state, Object sourceObject, Object targetObject, String functionName, boolean valueIsCollection) {
        if (valueIsCollection) {
            Collection<Object> sourceList = this.getListValue(node, sourceObject);
            Collection<Object> targetList = this.getListValue(node, targetObject);
            Collection<Object> addItemList = this.listSubtract(targetList, sourceList);
            Collection<Object> delItemList = this.listSubtract(sourceList, targetList);
            String listAddContent = this.listToContent(functionName, addItemList);
            String listDelContent = this.listToContent(functionName, delItemList);
            return this.logRecordProperties.formatList(filedLogName, listAddContent, listDelContent);
        }
        switch (state) {
            case ADDED: {
                return this.logRecordProperties.formatAdd(filedLogName, this.getFunctionValue(this.getFieldValue(node, targetObject), functionName));
            }
            case CHANGED: {
                return this.logRecordProperties.formatUpdate(filedLogName, this.getFunctionValue(this.getFieldValue(node, sourceObject), functionName), this.getFunctionValue(this.getFieldValue(node, targetObject), functionName));
            }
            case REMOVED: {
                return this.logRecordProperties.formatDeleted(filedLogName, this.getFunctionValue(this.getFieldValue(node, sourceObject), functionName));
            }
        }
        log.warn("diff log not support");
        return "";
    }

    private Collection<Object> getListValue(DiffNode node, Object object) {
        Object fieldSourceValue = this.getFieldValue(node, object);
        return fieldSourceValue == null ? Lists.newArrayList() : (Collection)fieldSourceValue;
    }

    private Collection<Object> listSubtract(Collection<Object> minuend, Collection<Object> subTractor) {
        ArrayList<Object> addItemList = new ArrayList<Object>(minuend);
        addItemList.removeAll(subTractor);
        return addItemList;
    }

    private String listToContent(String functionName, Collection<Object> addItemList) {
        StringBuilder listAddContent = new StringBuilder();
        if (!CollectionUtils.isEmpty(addItemList)) {
            for (Object item : addItemList) {
                listAddContent.append(this.getFunctionValue(item, functionName)).append(this.logRecordProperties.getListItemSeparator());
            }
        }
        return listAddContent.toString().replaceAll(this.logRecordProperties.getListItemSeparator() + "$", "");
    }

    private String getFunctionValue(Object canonicalGet, String functionName) {
        if (StringUtils.isEmpty((Object)functionName)) {
            return canonicalGet.toString();
        }
        return this.functionService.apply(functionName, canonicalGet.toString());
    }

    private Object getFieldValue(DiffNode node, Object o2) {
        return node.canonicalGet(o2);
    }

    public DefaultDiffItemsToLogContentService(IFunctionService functionService, LogRecordProperties logRecordProperties) {
        this.functionService = functionService;
        this.logRecordProperties = logRecordProperties;
    }
}

