/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.starter.configuration;

import com.mzt.logapi.service.IFunctionService;
import com.mzt.logapi.service.ILogRecordService;
import com.mzt.logapi.service.IOperatorGetService;
import com.mzt.logapi.service.IParseFunction;
import com.mzt.logapi.service.impl.DefaultFunctionServiceImpl;
import com.mzt.logapi.service.impl.DefaultLogRecordServiceImpl;
import com.mzt.logapi.service.impl.DefaultOperatorGetServiceImpl;
import com.mzt.logapi.service.impl.DefaultParseFunction;
import com.mzt.logapi.service.impl.DiffParseFunction;
import com.mzt.logapi.service.impl.ParseFunctionFactory;
import com.mzt.logapi.starter.annotation.EnableLogRecord;
import com.mzt.logapi.starter.configuration.LogRecordProperties;
import com.mzt.logapi.starter.diff.DefaultDiffItemsToLogContentService;
import com.mzt.logapi.starter.diff.IDiffItemsToLogContentService;
import com.mzt.logapi.starter.support.aop.BeanFactoryLogRecordAdvisor;
import com.mzt.logapi.starter.support.aop.LogRecordInterceptor;
import com.mzt.logapi.starter.support.aop.LogRecordOperationSource;
import com.mzt.logapi.starter.support.parse.LogFunctionParser;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
@EnableConfigurationProperties(value={LogRecordProperties.class})
public class LogRecordProxyAutoConfiguration
implements ImportAware {
    private static final Logger log = LoggerFactory.getLogger(LogRecordProxyAutoConfiguration.class);
    private AnnotationAttributes enableLogRecord;

    @Bean
    @Role(value=2)
    public LogRecordOperationSource logRecordOperationSource() {
        return new LogRecordOperationSource();
    }

    @Bean
    @ConditionalOnMissingBean(value={IFunctionService.class})
    public IFunctionService functionService(ParseFunctionFactory parseFunctionFactory) {
        return new DefaultFunctionServiceImpl(parseFunctionFactory);
    }

    @Bean
    public ParseFunctionFactory parseFunctionFactory(@Autowired List<IParseFunction> parseFunctions) {
        return new ParseFunctionFactory(parseFunctions);
    }

    @Bean
    @ConditionalOnMissingBean(value={IParseFunction.class})
    public DefaultParseFunction parseFunction() {
        return new DefaultParseFunction();
    }

    @Bean
    @Role(value=2)
    public BeanFactoryLogRecordAdvisor logRecordAdvisor(IFunctionService functionService, DiffParseFunction diffParseFunction) {
        BeanFactoryLogRecordAdvisor advisor = new BeanFactoryLogRecordAdvisor();
        advisor.setLogRecordOperationSource(this.logRecordOperationSource());
        advisor.setAdvice((Advice)this.logRecordInterceptor(functionService, diffParseFunction));
        return advisor;
    }

    @Bean
    @Role(value=2)
    public LogRecordInterceptor logRecordInterceptor(IFunctionService functionService, DiffParseFunction diffParseFunction) {
        LogRecordInterceptor interceptor = new LogRecordInterceptor();
        interceptor.setLogRecordOperationSource(this.logRecordOperationSource());
        interceptor.setTenant(this.enableLogRecord.getString("tenant"));
        interceptor.setLogFunctionParser(this.logFunctionParser(functionService));
        interceptor.setDiffParseFunction(diffParseFunction);
        return interceptor;
    }

    @Bean
    public LogFunctionParser logFunctionParser(IFunctionService functionService) {
        return new LogFunctionParser(functionService);
    }

    @Bean
    public DiffParseFunction diffParseFunction(IDiffItemsToLogContentService diffItemsToLogContentService) {
        DiffParseFunction diffParseFunction = new DiffParseFunction();
        diffParseFunction.setDiffItemsToLogContentService(diffItemsToLogContentService);
        return diffParseFunction;
    }

    @Bean
    @ConditionalOnMissingBean(value={IDiffItemsToLogContentService.class})
    @Role(value=0)
    public IDiffItemsToLogContentService diffItemsToLogContentService(IFunctionService functionService, LogRecordProperties logRecordProperties) {
        return new DefaultDiffItemsToLogContentService(functionService, logRecordProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={IOperatorGetService.class})
    @Role(value=0)
    public IOperatorGetService operatorGetService() {
        return new DefaultOperatorGetServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={ILogRecordService.class})
    @Role(value=0)
    public ILogRecordService recordService() {
        return new DefaultLogRecordServiceImpl();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableLogRecord = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableLogRecord.class.getName(), false));
        if (this.enableLogRecord == null) {
            log.info("@EnableCaching is not present on importing class");
        }
    }
}

